(function($) {

    $.su = $.su || {};
    $.su.CHAR = $.su.CHAR || {};
    $.su.CHAR.HELP = {
        STATUS_INTERNET: {
            TITLE: "Internet",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Afficher les informations relatives à la connexion internet (WAN)."
                }, {
                    type: "title",
                    title: "IPv4"
                }, {
                    type: "name",
                    title: "Adresse MAC",
                    content: "L'Adresse MAC unique assignée au port WAN du routeur."
                }, {
                    type: "name",
                    title: "Adresse IP",
                    content: "L'adresse IP attribuée au port WAN (internet) du routeur. Si l'adresse IP est 0.0.0.0 c'est qu'il n'y à aucun accès internet."
                }, {
                    type: "name",
                    title: "Masque de sous-réseau ",
                    content: "Ce paramètre détermine la taille du sous-réseau pour une adresse IP."
                }, {
                    type: "name",
                    title: "Passerelle par défaut",
                    content: "L'adresse IP utilisée pour connecter le routeur au réseau."
                }, {
                    type: "name",
                    title: "DNS primaire/secondaire",
                    content: "Le DNS (Domaine Name System) traduit les noms d'hôtes et les domaines internet en leur adresse IP. Les informations concernant ces serveurs DNS sont assignées par le FAI (Fournisseur d'accès à internet)."
                }, {
                    type: "name",
                    title: "Type de connexion",
                    content: "Le type de la connexion internet actuelle au port WAN."
                }, {
                    type: "title",
                    title: "IPv6"
                }, {
                    type: "name",
                    title: "Adresse MAC",
                    content: "L'Adresse MAC unique assignée au port WAN du routeur."
                }, {
                    type: "name",
                    title: "Adresse IP",
                    content: "L'adresse IP attribuée au port WAN (internet) du routeur."
                }, {
                    type: "name",
                    title: "Passerelle par défaut",
                    content: "L'adresse IP utilisée pour connecter le routeur au réseau."
                }, {
                    type: "name",
                    title: "DNS primaire/secondaire",
                    content: "Le DNS (Domaine Name System) traduit les noms d'hôtes et les domaines internet en leur adresse IP. Les informations concernant ces serveurs DNS sont assignées par le FAI (Fournisseur d'accès à internet)."
                }, {
                    type: "name",
                    title: "Type de connexion",
                    content: "Le type de la connexion internet actuelle au port WAN."
                }
            ]
        },
        STATUS_PLC_NTW: {
            TITLE: "Réseau CPL",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Cliquer sur l'icône réseau CPL pour afficher la liste de tous les CPL appartenant au réseau CPL."
                }
            ]
        },
        STATUS_PLC: {
            TITLE: "CPL",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Cliquer sur l'icône CPL pour afficher les informations détaillées du CPL local."
                }, {
                    type: "name",
                    title: "Adresse MAC",
                    content: "L'identifiant unique assigné à l'extenseur CPL."
                }, {
                    type: "name",
                    title: "Mot de passe CPL",
                    content: "Mot de passe CPL (unique) utilisé pour ajouter cet appareil au réseau CPL. Ce mot de passe est aussi imprimé sur l'étiquette présente sur le produit."
                }, {
                    type: "name",
                    title: "Nom de réseau",
                    content: "Le nom du réseau CPL auquel appartient l'extenseur. La valeur par défaut est HomePlugAV."
                }
            ]
        },
        STATUS_WIRELESS: {
            TITLE: "Réseau Wi-Fi 2.4 GHz<span class=\"anti_5g\">/5 GHz</span>",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Indique l'état et les informations basiques du réseau Wi-Fi."
                }, {
                    type: "name",
                    title: "Etat",
                    content: "L'état actuel (Actif ou Inactif) de votre réseau Wi-Fi."
                }, {
                    type: "name",
                    title: "SSID",
                    content: "Service Set Identifier, aussi appelé nom du réseau Wi-Fi."
                }, {
                    type: "name",
                    title: "Canal",
                    content: "Le canal Wi-Fi actuel."
                }, {
                    type: "name",
                    title: "ADRESSE MAC",
                    content: "L'adresse MAC Wi-Fi de l'extenseur."
                }
            ]
        },
        STATUS_LAN: {
            TITLE: "LAN",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Indique les informations relatives aux ports Ethernet LAN."
                }, {
                    type: "title",
                    title: "IPv4"
                }, {
                    type: "name",
                    title: "Adresse MAC",
                    content: "L'adresse MAC unique assignée au port LAN du routeur."
                }, {
                    type: "name",
                    title: "Adresse IP",
                    content: "L'adresse IPv4 assignée au port Ethernet LAN du routeur."
                }, {
                    type: "name",
                    title: "Masque de sous-réseau ",
                    content: "Ce paramètre détermine la taille du sous-réseau pour une adresse IP."
                }, {
                    type: "name",
                    title: "DHCP",
                    content: "indique si le serveur DHCP du serveur est actif pour les clients connectés au port LAN ou non."
                }, {
                    type: "title",
                    title: "IPv6"
                }, {
                    type: "name",
                    title: "Adresse MAC",
                    content: "L'adresse MAC unique assignée au port LAN du routeur."
                }, {
                    type: "name",
                    title: "Adresse IP",
                    content: "L'adresse IPv6 attribuée au port LAN (internet) du routeur."
                }, {
                    type: "name",
                    title: "Adresse locale du lien",
                    content: "L'adresse IPv6 de lien pour l'interface LAN."
                }, {
                    type: "name",
                    title: "Type assigné",
                    content: "Le type d'adresse IPv6 pour l'interface LAN."
                }
            ]
        },
        STATUS_GUEST: {
            TITLE: "Réseau invités 2.4 GHz<span class=\"anti_5g\">/5 GHz</span>",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Affiche les informations du réseau Wi-Fi invités."
                }, {
                    type: "name",
                    title: "Etat",
                    content: "L'état actuel (Actif ou Inactif) de votre réseau invités."
                }, {
                    type: "name",
                    title: "SSID",
                    content: "Le nom de votre réseau Wi-Fi invités."
                }
            ]
        },
        STATUS_USB: {
            TITLE: "Services USB",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Afficher les informations des périphériques de stockage / imprimantes USB connectés au routeur."
                }, {
                    type: "name",
                    title: "Imprimante",
                    content: "Le nom de l'imprimante connectée."
                }, {
                    type: "name",
                    title: "Total ",
                    content: "La capacité totale du périphérique de stockage USB connecté."
                }, {
                    type: "name",
                    title: "Disponible",
                    content: "La capacité disponible du périphérique de stockage USB connecté."
                }
            ]
        },
        STATUS_PERFORMANCE: {
            TITLE: "Performances",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Affiche les performances actuelles du routeur."
                }, {
                    type: "name",
                    title: "Charge processeur",
                    content: "L'utilisation actuelle du processeur."
                }, {
                    type: "name",
                    title: "Mémoire utilisée",
                    content: "L'utilisation actuelle de la mémoire."
                }
            ]
        },
        STATUS_WIRED: {
            TITLE: "Clients Filaires",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Affiche les informations de tous les appareils connectés en Ethernet au réseau."
                }
            ]
        },
        STATUS_WIRELESS_CLIENTS: {
            TITLE: "Clients Wi-Fi",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Cliquer sur l'icône clients Wi-Fi pour afficher les informations relatives à tous les client Wi-Fi connectés au réseau généré par l'extenseur CPL."
                }, {
                    type: "name",
                    title: "Adresse MAC",
                    content: "L'adresse MAC du client Wi-Fi."
                }, {
                    type: "name",
                    title: "Bande Wi-Fi",
                    content: "La bande Wi-Fi <span class=\"anti_5g\">(2.4 GHz ou 5 GHz) </span>à laquelle le client est connecté."
                }
            ]
        },
        STATUS_WIFI_MOVE: {
            TITLE: "Wi-Fi move",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Indique si la fonction Wi-Fi Move est active ou non."
                }
            ]
        },
        INTERNET_INTERNET: {
            TITLE: "IPv4",
            CONTENT: [
                {
                    type: "title",
                    title: "Type de connexion internet : IP Statique"
                }, {
                    type: "paragraph",
                    content: "Cocher cette case si votre FAI fourni une connexion par IP Fixe avec un masque de sous-réseau n une passerelle et des paramètres DNS spécifiques."
                }, {
                    type: "name",
                    title: "Adresse IP/Masque de sous-réseau/Passerelle par défaut/DNS primaire/DNS secondaire",
                    content: "Saisir les informations fournies par votre ISP."
                }, {
                    type: "name",
                    title: "Taille de la MTU",
                    content: "La taille de MTU (Maximum Transmission Unit) typique pour la plupart des réseaux Ethernet est de 1500 Octets. Il n'EST pas recommandé de modifier la taille par défaut de la MTU sauf si votre FAI le requiert."
                }, {
                    type: "title",
                    title: "Type de connexion internet : IP Dynamique"
                }, {
                    type: "paragraph",
                    content: "Choisir ce type si votre FAI (Fournisseur d'Accès à Internet) propose un serveur DHCP."
                }, {
                    type: "name",
                    title: "Adresse IP/Masque de sous-réseau/Passerelle par défaut/DNS primaire/DNS secondaire",
                    content: "Ces paramètres sont automatiquement assignés par le serveur DHCP de votre FAI."
                }, {
                    type: "name",
                    title: "Renouveler",
                    content: "Cliquer sur ce bouton pour obtenir de nouveaux paramètres IP de la part du serveur DHCP."
                }, {
                    type: "name",
                    title: "Relâcher",
                    content: "Cliquer sur ce bouton pour libérer toutes les adresses IP assignées par le serveur DHCP."
                }, {
                    type: "name",
                    title: "Utiliser les adresses DNS suivantes",
                    content: "Si le FAI fourni une ou deux adresses DNS, cocher cette case et saisir le DNS primaire et le DNS secondaire dans les champs dédiés, sinon les adresses DNS seront assignées dynamiquement par le FAI."
                }, {
                    type: "name",
                    title: "Taille de la MTU",
                    content: "La taille de MTU (Maximum Transmission Unit) typique pour la plupart des réseaux Ethernet est de 1500 Octets. Il n'EST pas recommandé de modifier la taille par défaut de la MTU sauf si votre FAI le requiert."
                }, {
                    type: "name",
                    title: "Nom d'hôte",
                    content: "Saisir une valeur dans ce champ pour spécifier le nom d'hôte du routeur."
                }, {
                    type: "name",
                    title: "Obtenir une IP par DHCP unicast",
                    content: "Cocher cette case si le serveur DHCP De votre FAI ne supporte pas les demandes Broadcast et que vous ne pouvez pas obtenir une adresse dynamiquement."
                }, {
                    type: "note",
                    title: "Remarque",
                    content: "Si vous constatez des erreurs du type ''Adresse non trouvée\" après saisie manuelle des DNS, c'est a priori en raison d'une saisie incorrecte ou un problème de DNS, contactez votre FAI."
                }, {
                    type: "title",
                    title: "Type de connexion internet : PPPoE"
                }, {
                    type: "paragraph",
                    content: "Choisir ce type si vous accédez à internet via une connexion DSL (Digital Subscriber Line) et que votre FAI vous fourni un Nom d'utilisateur et un mot de passe."
                }, {
                    type: "name",
                    title: "Nom d'utilisateur / Mot de passe",
                    content: "Saisir le nom d'utilisateur et le mot de passe fournis par votre FAI. Ces champs différencient minuscules et majuscules"
                }, {
                    type: "name",
                    title: "Adresse IP internet/DNS primaire/DNS secondaire",
                    content: "Ces paramètres sont automatiquement assignés par le serveur DHCP de votre FAI."
                }, {
                    type: "name",
                    title: "Connexion secondaire (IP dynamique ou statique)",
                    children: [
                        {
                            type: "name",
                            title: "Aucun(e)",
                            content: "Sélectionner si aucune connexion secondaire n'est fournie."
                        }, {
                            type: "name",
                            title: "IP dynamique",
                            content: "Sélectionner dans le cas ou l'adresse IP et le masque de sous réseau sont assignés automatiquement par le FAI.",
                            children: [
                                {
                                    type: "name",
                                    title: "Renouveler",
                                    content: "Cliquer sur ce bouton pour renouveler les paramètres IP fournis par votre FAI."
                                }, {
                                    type: "name",
                                    title: "Relâcher",
                                    content: "Cliquer sur ce bouton pour libérer les paramètres IP assignés."
                                }
                            ]
                        }, {
                            type: "name",
                            title: "IP Statique",
                            content: "Sélectionner dans le cas ou l'adresse IP, le masque de sous réseau, la passerelle, et les adresse DNS sont assignés automatiquement par le FAI, et saisir ces informations dans les champs correspondants."
                        }
                    ]
                }, {
                    type: "name",
                    title: "Taille de la MTU",
                    content: "La taille de MTU (Maximum Transmission Unit) typique pour les réseaux Ethernet est de 1480 Octets.",
                    children: [
                        {
                            type: "note",
                            title: "Remarque",
                            content: "Dans de rares cas, votre FAI requiert la modification de la taille de la MTU pour augmenter les performances réseau. Vous ne devriez pas modifier la valeur sauf en cas de nécessité absolue."
                        }
                    ]
                }, {
                    type: "name",
                    title: "Nom de service/Nom de concentrateur d'accès",
                    content: "Par défaut, le Service Name et l'Access Concentrator (AC) Name sont laissés vierges. Ces champs ne devraient pas être configurés sauf si votre FAI le requiert."
                }, {
                    type: "name",
                    title: "Détection de l'intervalle en ligne",
                    content: "Saisir un intervalle de temps (0 à 120 s) séparant chaque détection de l'Access Concentrator par le routeur. La valeur par défaut est 0, signifiant pas de détection."
                }, {
                    type: "name",
                    title: "Adresse IP",
                    content: "Si votre FAI fourni une adresse IP fixe, sélectionner \"Utiliser l'adresse IP suivante\" et la saisir dans le champ dédié, sinon sélectionner \"Obtenir dynamiquement du FAI\" pour l'obtenir automatiquement."
                }, {
                    type: "name",
                    title: "Adresse DNS/DNS primaire/DNS secondaire",
                    content: "Si votre FAI fourni des adresses IP DNS fixes, sélectionner \"Utiliser les adresses DNS suivantes\" et saisir le DNS primaire et le DNS secondaire dans les champs dédiés, sinon sélectionner \"Obtenir dynamiquement du FAI\" pour obtenir les DNS assignés par votre FAI."
                }, {
                    type: "name",
                    title: "Mode de connexion",
                    content: "Sélectionner un mode de connexion approprié déterminant comment se connecter à internet.",
                    children: [
                        {
                            type: "name",
                            title: "Auto",
                            content: "Dans ce mode, la connexion internet est automatiquement renouvelée en cas de déconnexion."
                        }, {
                            type: "name",
                            title: "A la demande",
                            content: "Dans ce mode, la connexion internet est automatiquement déconnectée après un temps d'inactivité spécifiée (Temps d'inactivité maximal). La connexion est rétablie dès que vous tentez d'accéder à nouveau à internet."
                        }, {
                            type: "name",
                            title: "En fonction du temps",
                            content: "Dans ce mode, la connexion internet est établie dans une plage horaire spécifique. Si cette option est sélectionnée, saisir l'heure de début et celle de fin ; toutes deux au format HH:MM."
                        }, {
                            type: "name",
                            title: "Manuellement",
                            content: "Dans ce mode, la connexion internet est contrôlée manuellement en cliquant sur le bouton Connecter/Déconnecter. Ce mode supporte aussi la fonction de durée d'inactivité maximal. Saisir une durée maximale (en minutes) d'inactivité de la connexion internet avant qu'elle soit interrompue dans le champ ''Temps d'inactivité maxi\". La valeur par défaut est 15 minutes. Si vous voulez que le connexion internet reste active de façon permanente, saisir 0 (zéro)."
                        }, {
                            type: "note",
                            title: "Remarque",
                            content: "Le mode de connexion en fonction des horaires, ne prendra effet qu'une fois les Paramètres horaires du sous-menu Outils système dans l'onglet Avancé paramétrés."
                        }
                    ]
                }, {
                    type: "title",
                    title: "Type de connexion internet : BigPond Cable"
                }, {
                    type: "paragraph",
                    content: "Sélectionner ce type si votre FAI vous fourni une connexion de type BigPond Cable."
                }, {
                    type: "name",
                    title: "Nom d'utilisateur / Mot de passe",
                    content: "Saisir le nom d'utilisateur et le mot de passe fournis par votre FAI. Ces champs différencient minuscules et majuscules"
                }, {
                    type: "name",
                    title: "Serveur Auth.",
                    content: "Saisir l'adresse IP ou le nom de domaine du serveur d'authentification."
                }, {
                    type: "name",
                    title: "Domaine Auth.",
                    content: "Saisir le suffixe du nom de domaine du serveur (dépend de votre pays). Par exemple, nsw.bigpond.net.au pour NSW/ACT, vic.bigpond.net.au pour VIC/TAS/WA/SA/NT, ou qld.bigpond.net.au pour QLD."
                }, {
                    type: "name",
                    title: "Taille de la MTU",
                    content: "La taille de MTU (Maximum Transmission Unit) typique pour la plupart des réseaux Ethernet est de 1500 Octets. Il n'EST pas recommandé de modifier la taille par défaut de la MTU sauf si votre FAI le requiert."
                }, {
                    type: "name",
                    title: "Mode de connexion",
                    content: "Sélectionner un mode de connexion approprié déterminant comment se connecter à internet.",
                    children: [
                        {
                            type: "name",
                            title: "Auto",
                            content: "Dans ce mode, la connexion internet est automatiquement renouvelée en cas de déconnexion."
                        }, {
                            type: "name",
                            title: "A la demande",
                            content: "Dans ce mode, la connexion internet est automatiquement déconnectée après un temps d'inactivité spécifiée (Temps d'inactivité maximal). La connexion est rétablie dès que vous tentez d'accéder à nouveau à internet."
                        }, {
                            type: "name",
                            title: "Manuellement",
                            content: "Dans ce mode, la connexion internet est contrôlée manuellement en cliquant sur le bouton Connecter/Déconnecter. Ce mode supporte aussi la fonction de durée d'inactivité maximal. Saisir une durée maximale (en minutes) d'inactivité de la connexion internet avant qu'elle soit interrompue dans le champ ''Temps d'inactivité maxi\". La valeur par défaut est 15 minutes. Si vous voulez que le connexion internet reste active de façon permanente, saisir 0 (zéro)."
                        }
                    ]
                }, {
                    type: "title",
                    title: "Type de connexion internet : L2TP/PPTP"
                }, {
                    type: "paragraph",
                    content: "Sélectionner ce type si vous vous connectez à un serveur VPN L2TP/PPTP et que le FAI vous a fourni, le nom d'utilisateur, le mot de passe l'adresse IP ou le nom de domaine du serveur."
                }, {
                    type: "name",
                    title: "Nom d'utilisateur / Mot de passe",
                    content: "Saisir le nom d'utilisateur et le mot de passe fournis par votre FAI. Ces champs différencient minuscules et majuscules"
                }, {
                    type: "name",
                    title: "Adresse IP internet/DNS primaire/DNS secondaire",
                    content: "Ces paramètres seront automatiquement assignés par le serveur DHCP de votre FAI."
                }, {
                    type: "name",
                    title: "Connexion secondaire (IP dynamique ou statique)",
                    children: [
                        {
                            type: "name",
                            title: "IP dynamique",
                            content: "Sélectionner dans le cas ou l'adresse IP et le masque de sous réseau sont assignés automatiquement par le FAI.",
                            children: [
                                {
                                    type: "name",
                                    title: "Renouveler",
                                    content: "Cliquer sur ce bouton pour renouveler les paramètres IP fournis par votre FAI."
                                }, {
                                    type: "name",
                                    title: "Relâcher",
                                    content: "Cliquer sur ce bouton pour libérer les paramètres IP assignés."
                                }
                            ]
                        }, {
                            type: "name",
                            title: "IP Statique",
                            content: "Sélectionner dans le cas ou l'adresse IP, le masque de sous réseau, la passerelle, et les adresse DNS sont assignés automatiquement par le FAI, et saisir ces informations dans les champs correspondants."
                        }
                    ]
                }, {
                    type: "name",
                    title: "IP de serveur VPN/Nom de domaine",
                    content: "Saisir l'adresse IP du serveur VPN ou le nom de domaine fourni par votre FAI."
                }, {
                    type: "name",
                    title: "Taille de la MTU",
                    content: "La taille de MTU (Maximum Transmission Unit) typique pour la plupart des réseaux Ethernet est de 1460 Octets. Il n'EST pas recommandé de modifier la taille par défaut de la MTU sauf si votre FAI le requiert."
                }, {
                    type: "name",
                    title: "Mode de connexion",
                    content: "Sélectionner un mode de connexion approprié déterminant comment se connecter à internet.",
                    children: [
                        {
                            type: "name",
                            title: "Auto",
                            content: "Dans ce mode, la connexion internet est automatiquement renouvelée en cas de déconnexion."
                        }, {
                            type: "name",
                            title: "A la demande",
                            content: "Dans ce mode, la connexion internet est automatiquement déconnectée après un temps d'inactivité spécifiée (Temps d'inactivité maximal). La connexion est rétablie dès que vous tentez d'accéder à nouveau à internet."
                        }, {
                            type: "name",
                            title: "Manuellement",
                            content: "Dans ce mode, la connexion internet est contrôlée manuellement en cliquant sur le bouton Connecter/Déconnecter. Ce mode supporte aussi la fonction de durée d'inactivité maximal. Saisir une durée maximale (en minutes) d'inactivité de la connexion internet avant qu'elle soit interrompue dans le champ ''Temps d'inactivité maxi\". La valeur par défaut est 15 minutes. Si vous voulez que le connexion internet reste active de façon permanente, saisir 0 (zéro)."
                        }
                    ]
                }
            ]
        },
        HELP_PLC_STATION: {
            TITLE: "Liste des CPL",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Affiche les informations de tous les CPL connectés au circuit électrique et appartenant au même réseau CPL."
                }, {
                    type: "name",
                    title: "Appareil local",
                    content: "L'extenseur CPL auquel vous êtes connecté."
                }, {
                    type: "step",
                    content: ["Dans la liste des CPL, L'adresse MAC et le débit CPL mesuré du CPL correspondant sont affichés de gauche à droite.", "Cliquer sur l'icone <b>Plus</b> pour ajouter au réseau, un extenseur CPL à l'aide de son mot de passe CPL.", "Cliquer sur l'icone <b>Plus</b> pour ajouter au réseau, un extenseur CPL à l'aide de son mot de passe CPL."]
                }, {
                    type: "name",
                    title: "Retour",
                    content: "Cliquer pour retourner à la page d'état."
                }, {
                    type: "name",
                    title: "Rafraîchir",
                    content: "Cliquer pour rafraichir la page."
                }
            ]
        },
        INTERNET_MAC: {
            TITLE: "Clonage d'adresse MAC",
            CONTENT: [
                {
                    type: "name",
                    title: "Utiliser l'adresse MAC par défaut",
                    content: "NE pas changer l'adresse MAC par défaut du routeur, au cas ou le FAI n'associe pas l'adresse IP assignée à l'adresse MAC."
                }, {
                    type: "name",
                    title: "Utiliser l'adresse MAC de l'ordinateur",
                    content: "Sélectionner pour copier l'adresse MAC de l'ordinateur connecté au routeur, au cas ou le FAI associe l'adresse IP associée à l'adresse MAC de cet ordinateur."
                }, {
                    type: "name",
                    title: "Utiliser une adresse MAC personnalisée",
                    content: "Saisir l'adresse MAC manuellement, au cas ou le FAI associe l'adresse IP assignée à une adresse MAC spécifique."
                }
            ]
        },
        LAN_IPV4: {
            TITLE: "Paramètres LAN",
            CONTENT: [
                {
                    type: "name",
                    title: "Type de LAN",
                    content: "Sélectionner IP dynamique ou IP statique."
                }, {
                    type: "name",
                    title: "IP dynamique",
                    content: "Sélectionner cette option pour obtenir automatiquement une adresse IP du serveur DHCP."
                }, {
                    type: "name",
                    title: "IP Statique",
                    content: "Sélectionner cette option pour définir manuellement l'adresse IP, le masque de sous-réseau et la passerelle par défaut."
                }, {
                    type: "name",
                    title: "Adresse IP",
                    content: "Affiche l'adresse IP par défaut de l'extenseur, utilisée pour accéder à l'interface Web de ce dernier et modifiable."
                }, {
                    type: "name",
                    title: "Masque de sous-réseau ",
                    content: "Sélectionner un identifiant utilisé par le port LAN depuis la liste déroulante, pour router le trafic interne et externe, ou saisir un nouveau masque de sous-réseau au format xxx.xxx.xxx.xxx"
                }, {
                    type: "name",
                    title: "Passerelle par défaut",
                    content: "L'adresse IP utilisée pour connecter l'extenseur au réseau."
                }, {
                    type: "paragraph",
                    content: "Cliquer sur <b>Sauvegarder</b> pour enregistrer tous vos paramètres."
                }
            ]
        },
        LED_TIME: {
            TITLE: "Programmation des DELs",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "La programmation des DELs vous permet d'allumer ou d'éteindre les DELs de cet extenseur CPL selon vos programmations horaires."
                }, {
                    type: "name",
                    title: "Programmateur de DEL",
                    content: "Basculer sur <b>On</b> pour activer la programmation des DELs."
                }
            ]
        },
        LED_TIME_GRID: {
            TITLE: "Planifications d'extinction de DELs",
            CONTENT: [
                {
                    type: "name",
                    title: "De ",
                    content: "Indique l'heure à laquelle les DELs seront éteintes."
                }, {
                    type: "name",
                    title: "à",
                    content: "Indique l'heure à laquelle les DELs seront de nouveau allumées."
                }, {
                    type: "name",
                    title: "Jour(s)",
                    content: "Affiche les jours concernés par la programmation."
                }, {
                    type: "name",
                    title: "Etat",
                    content: "Indique l'état actuel de la programmation correspondante. Cliquer sur l'icône <b>Ampoule</b> pour activer ou désactiver la programmation."
                }, {
                    type: "name",
                    title: "Modifier",
                    content: "Affiche les options pour<b>Modifier</b> ou <b>Supprimer</b> la programmation correspondante."
                }, {
                    type: "step",
                    title: "Pour créer une nouvelle programmation",
                    content: ["1. Cliquer sur <b>Ajouter</b>.", "2. Définir une plage horaire pendant laquelle les DELs seront éteintes.", "3. Sélectionner les jours de la semaine auxquels cette programmation s'appliquera.", "4. Sélectionner <b>Activer cet élément</b>.", "5. Cliquer sur <b>OK</b> pour sauvegarder les paramètres."]
                }, {
                    type: "paragraph",
                    content: "Pour modifier ou supprimer une programmation, cliquer sur l'icône <b>Editer</b> pour éditer les informations ou sur l'icône <b>Poubelle</b> pour supprimer la programmation correspondante."
                }, {
                    type: "paragraph",
                    content: "Pour supprimer plusieurs programmations, cocher les cases des éléments correspondants puis cliquer sur <b>Supprimer</b> au dessus de la liste."
                }
            ]
        },
        HELP_PLC: {
            TITLE: "CPL",
            CONTENT: [
                {
                    type: "name",
                    title: "Adresse MAC",
                    content: "L'adresse Physique unique attribuée au CPL."
                }, {
                    type: "name",
                    title: "Mot de passe CPL",
                    content: "Mot de passe CPL (unique) utilisé pour ajouter cet appareil au réseau CPL. Ce mot de passe est aussi imprimé sur l'étiquette présente sur le produit."
                }, {
                    type: "name",
                    title: "Nom de réseau",
                    content: "Indique le nom de réseau CPL auquel l'extenseur CPL appartient. Vous pouvez renommer le réseau ici ou cliquer sur Défaut pour le réinitialiser à son nom par défaut par exemple HomePlugAV. Notez que si le nom par défaut est utilisé, la fonction Wi-Fi move sera automatiquement désactivée."
                }
            ]
        },
        IPTV: {
            TITLE: "Paramètres",
            CONTENT: [
                {
                    type: "name",
                    title: "TV sur IP",
                    content: "Sélectionner pour activer la fonctionnalité IPTV."
                }, {
                    type: "name",
                    title: "Mode",
                    content: "Sélectionner le mode approprié requis par votre FAI. Il existe 6 modes TV par IP :",
                    children: [
                        {
                            type: "name",
                            title: "Pont",
                            content: "Si votre FAI n'est pas listé et qu'aucun autre paramètre n'est requis vous pouvez tester ce mode et configurer les fonctionnalités LAN du routeur.",
                            children: [
                                {
                                    type: "name",
                                    title: "LAN 1/2/3/4",
                                    content: "Assigner le port LAN à la fourniture d'internet ou de TV sur IP."
                                }
                            ]
                        }, {
                            type: "name",
                            title: "Russie",
                            content: "Sélectionner si votre FAI est Russe et que les paramètres requis sont prédéterminés et incluent : Internet, téléphonie IP, N° et priorité de Vlan IPTV, fonctions de port réseau (1/2/3/4).",
                            children: [
                                {
                                    type: "name",
                                    title: "N° de Vlan IPTV Multicast/Priorité",
                                    content: "Vous pouvez activer librement la fonction multicast IPTV, et configurer le N° de VLAN et les priorités selon les indications de votre FAI."
                                }
                            ]
                        }, {
                            type: "name",
                            title: "Singapore-ExStream",
                            content: "Sélectionner si votre FAI est ExStream (Singapour) et que les paramètres requis sont prédéterminés et incluent : Internet , N° et priorité de Vlan IPTV, fonctions de port réseau (1/2/3/4)."
                        }, {
                            type: "name",
                            title: "Malaysia-Unifi",
                            content: "Sélectionner si votre FAI est Unifi (Malaisie) et que les paramètres requis sont prédéterminés et incluent : Internet, N° et priorité de Vlan IPTV, fonctions de port réseau (1/2/3/4)."
                        }, {
                            type: "name",
                            title: "Malaysia-Maxis",
                            content: "Sélectionner si votre FAI est Maxis (Malaisie) et que les paramètres requis sont prédéterminés et incluent : Internet, téléphonie IP, N° et priorité de Vlan IPTV, fonctions de port réseau (1/2/3/4)."
                        }, {
                            type: "name",
                            title: "Personnalisé",
                            content: "Sélectionner si votre FAI n'est pas listé mais qu'il fourni les paramètres requis qui incluent : Internet, téléphonie IP, N° et priorité de Vlan IPTV, fonctions de port réseau (1/2/3/4).",
                            children: [
                                {
                                    type: "name",
                                    title: "Internet/Téléphone IP/N° de VLAN IPTV/Priorité",
                                    content: "configurer les N° de VLAN comme indiqué par votre FAI."
                                }, {
                                    type: "name",
                                    title: "Balise 802.11Q",
                                    content: "Sélectionner si vous voulez baliser les paquets internet avec 802.11Q."
                                }, {
                                    type: "name",
                                    title: "N° de Vlan IPTV Multicast/Priorité",
                                    content: "Vous pouvez activer librement la fonction multicast IPTV, et configurer le N° de VLAN et les priorités selon les indications de votre FAI."
                                }, {
                                    type: "name",
                                    title: "LAN 1/2/3/4",
                                    content: "Assigner le port LAN à la fourniture d'internet ou de TV sur IP."
                                }
                            ]
                        }
                    ]
                }, {
                    type: "name",
                    title: "Proxy IGMP",
                    content: "Sélectionner la version de proxy IGMP (Internet Group Management Protocol) V2 ou V3, en fonction de votre FAI."
                }
            ]
        },
        DHCP_SERVER_SETTINGS: {
            TITLE: "Paramètres",
            CONTENT: [
                {
                    type: "name",
                    title: "Serveur DHCP",
                    content: "Par défaut, le serveur DHCP (Dynamic Host Configuration Protocol) est activé, il assigne dynamiquement au clients leurs paramètres TCP/IP depuis la plage d'IP définie. NE pas désactiver le serveur DHCP sans disposer d'un serveur DHCP actif dans le réseau ou avant d'avoir défini manuellement les paramètres TCP/IP de chaque client de votre réseau."
                }, {
                    type: "name",
                    title: "Etendue d'adresse IP",
                    content: "Saisir l'étendue d'adresse IP qui peuvent être attribuées aux clients."
                }, {
                    type: "name",
                    title: "Bail d'adresse",
                    content: "Saisir la durée du bail pendant lequel l'adresse IP est réservée au client (2 à 2880 minutes). La valeur par défaut est 120 minutes."
                }, {
                    type: "name",
                    title: "Passerelle par défaut",
                    content: "Saisir l'adresse IP LAN. (Optionnel)."
                }, {
                    type: "name",
                    title: "DNS primaire/secondaire",
                    content: "Saisir ces paramètres tels que fournis par votre FAI. (Optionnel)."
                }
            ]
        },
        RESERVED_IP_ADDRESS: {
            TITLE: "Réservation d'adresse",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "vous pouvez réserver manuellement une adresse IP à un client connecté au routeur. Une fois réservée, l'adresse IP sera exclusivement assignée au même client par le serveur DHCP."
                }, {
                    type: "name",
                    title: "Adresse MAC",
                    content: "Indique l'adresse MAC du client dont l'adresse IP a été réservée."
                }, {
                    type: "name",
                    title: "Adresse IP attribuée",
                    content: "Indique l'adresse IP réservée du client."
                }, {
                    type: "name",
                    title: "Description",
                    content: "Affiche une description de l'appareil client."
                }, {
                    type: "name",
                    title: "Etat",
                    content: "Affiche l'état actuel (actif ou inactif) de l'appareil client."
                }, {
                    type: "name",
                    title: "Modifier",
                    content: "Affiche les options pour Modifier ou Supprimer le client correspondant."
                }, {
                    type: "step",
                    title: "Pour réserver une adresse IP",
                    content: [
                        "1. Cliquer sur Ajouter.",
                        "2. Saisir l'adresse MAC du client souhaité.",
                        "3. Saisir l'adresse IP que vous souhaitez réserver pour le client.",
                        "4. Saisir une description pour le client.",
                        "5. Sélectionner Activer.",
                        "6. Cliquer sur OK."
                    ]
                }, {
                    type: "step",
                    title: "Pour modifier ou supprimer un client existant",
                    content: "Dans la liste, cliquer sur l'icône Editer ou Supprimer qui correspond au client que vous souhaitez modifier ou supprimer."
                }
            ]
        },
        DHCP_CLIENT_LIST: {
            TITLE: "Liste de clients DHCP",
            CONTENT: [
                {
                    type: "name",
                    title: "Numéro de client",
                    content: "Indique le numéro du client DHCP associé."
                }, {
                    type: "name",
                    title: "Nom de client",
                    content: "Indique le nom du client DHCP."
                }, {
                    type: "name",
                    title: "Adresse MAC",
                    content: "Indique l'adresse MAC."
                }, {
                    type: "name",
                    title: "Adresse IP assignée",
                    content: "Indique l'adresse IP allouée au client par le serveur DHCP."
                }, {
                    type: "name",
                    title: "Durée du bail",
                    content: "Indique la durée du bail d'adresse IP qui a été attribuée au client."
                }, {
                    type: "name",
                    title: "Rafraîchir",
                    content: "Cliquer pour mettre à jour la liste des clients DHCP."
                }
            ]
        },
        DDNS: {
            TITLE: "DNS Dynamique",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Les DNS dynamiques vous permettent d'assigner un nom de domaine et d'hôte fixe à une adresse IP internet dynamique. Il est pratique quand vous hébergez votre site Web, votre serveur FTP, ou tout autre serveur connecté à votre routeur. Vous devez au préalable ouvrir un compte chez un fournisseur de service DDNS tel que www.dyndns.com"
                }, {
                    type: "step",
                    title: "Pour définir un DNS dynamique",
                    content: ["1. Sélectionner votre fournisseur de service DDNS.", "2. Saisir les identifiants de votre compte DDNS (Nom d'utilisateur et mot de passe).", "3. Saisir le nom de domaine attribué par votre fournisseur de service DDNS.", "4. Sélectionner l'Intervalle de mise à jour depuis la liste déroulante.", "5. Cliquer sur Se connecter et Sauvegarder."]
                }, {
                    type: "paragraph",
                    content: "Pour basculer d'un compte à un autre, vous devez vous déconnecter du compte utilisé et vous connecter à l'autre compte à l'aide de son nom d'utilisateur et de son mot de passe."
                }
            ]
        },
        ADVANCED_ROUTING_STATIC_ROUTING: {
            TITLE: "Routage statique",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Le routage statique est utilisé pour prédéterminer une route statique pour que les paquets réseau atteignent un réseau ou un hôte spécifique."
                }, {
                    type: "step",
                    title: "Pour définir un routage statique",
                    content: [
                        "1. Cliquer sur Ajouter.",
                        "2. Réseau de destination - Saisir une adresse IP en hexadécimal pour assigner une route statique à cet élément.",
                        "3. Masque de sous réseau - Saisir un masque de sous-réseau au format hexadécimal pour spécifier la taille du sous réseau de l'adresse IP.",
                        "4. Passerelle par défaut - Saisir une adresse IP en format hexadécimal pour connecter le routeur au réseau ou à un hôte.",
                        "5. Interface - Sélectionner LAN ou WAN pour définir le type du réseau de destination.",
                        "6. Description - Saisir une brève description pour cet élément.",
                        "7. Sélectionner Activer.",
                        "8. Cliquer sur OK."
                    ]
                }, {
                    type: "step",
                    title: "Pour modifier ou effacer un élément existant",
                    content: "Dans la liste, cliquer sur l'icône Editer ou Supprimer qui correspond à l'élément que vous souhaitez modifier ou supprimer."
                }
            ]
        },
        ADVANCED_ROUTING_SYSTEM_ROUTING: {
            TITLE: "Table de routage système",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "La table de routage système affiche toutes les routes valides en cours d'utilisation."
                }, {
                    type: "paragraph",
                    content: "Cliquer sur Rafraichir pour mettre à jour la table de routage."
                }
            ]
        },
        WIRELESS_REGION: {
            TITLE: "Paramètres",
            CONTENT: [
                {
                    type: "name",
                    title: "Pays",
                    content: "Sélectionner votre pays depuis la liste déroulante. Si votre pays n'est pas listé, il est peut-être interdit d'utiliser le Wi-Fi."
                }, {
                    type: "paragraph",
                    content: "Cliquer sur <b>Sauvegarder</b> pour enregistrer tous vos paramètres."
                }
            ]
        },
        WIRELESS_BOTH: {
            TITLE: "Wi-Fi",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Les instructions suivantes sont pour les réseaux Wi-Fi <span class=\"anti_5g\">2.4 et 5 GHz</span>."
                }, {
                    type: "name",
                    title: "Activer l'émission du Wi-Fi",
                    content: "Cocher cette case pour activer l'émission du signal Wi-Fi."
                }, {
                    type: "name",
                    title: "Nom de réseau (SSID)",
                    content: "Vous pouvez laisser le nom de réseau (SSID) par défaut ou en créer un autre (de 32 caractères au maximum). Champ différenciant minuscules des majuscules."
                }, {
                    type: "name",
                    title: "Cacher le SSID",
                    content: "Cocher cette case si vous souhaitez ne pas diffuser le SSID du réseau correspondant."
                }, {
                    type: "name",
                    title: "Mot de passe",
                    content: "Générer un mot de passe comprenant 8 à 63 caractères ASCII, ou entre 8 et 64 caractères hexadécimaux (0-9, A-F, a-f) pour sécuriser ce réseau Wi-Fi."
                }, {
                    type: "name",
                    title: "Avancé",
                    content: "Cliquer pour afficher des paramètres plus détaillés."
                }, {
                    type: "name",
                    title: "Sécurité",
                    content: "Choisir l'une des options de sécurité suivantes :",
                    children: [
                        {
                            type: "name",
                            title: "Pas de sécurité",
                            content: "Sélectionner cette option pour désactiver la sécurisation du Wi-Fi. Il est <b>fortement recommandé</b> d'activer la sécurité Wi-Fi pour protéger votre réseau Wi-Fi de tout accès non autorisé."
                        }, {
                            type: "name",
                            title: "WPA/WPA2 Personnel",
                            content: "Sélectionner cette option pour activer une méthode d'authentification standard basée sur une clé PSK (Pre Shared Key), aussi appelée mot de passe. Cette option est recommandée. Si sélectionné, configurer.",
                            children: [
                                {
                                    type: "name",
                                    title: "Version",
                                    content: "Choisir une version de sécurité pour votre réseau Wi-Fi.",
                                    children: [
                                        {
                                            type: "name",
                                            title: "Auto",
                                            content: "Cette option supporte de multiples implémentations du standard WPA (Wi-Fi Protected Access) telles WPA et WPA2."
                                        }, {
                                            type: "name",
                                            title: "WPA-PSK",
                                            content: "Cette option supporte les chiffrements TKIP et AES."
                                        }, {
                                            type: "name",
                                            title: "WPA2-PSK",
                                            content: "Cette option offre un meilleur niveau de sécurité que WPA-PSK et elle est recommandée."
                                        }
                                    ]
                                }, {
                                    type: "name",
                                    title: "Chiffrement",
                                    content: "Sélectionner un type de chiffrement : <b>TKIP</b>(Temporal Key Integrity Protocol), <b>AES</b>(Advanced Encryption Standard) ou <b>Auto</b> (pour TKIP & AES). il n'<b>EST</b> pas recommandé d'utiliser le chiffrement TKIP si l'extenseur CPL utilise le standard 802.11n car ce chiffrement ne fait pas partie des spécifications 802.11n."
                                }
                            ]
                        }, {
                            type: "name",
                            title: "WEP",
                            content: "Sélectionner cette option pour activer une méthode d'authentification basique si l'un de vos clients Wi-Fi ne peut utiliser que WEP (Wired Equivalent Privacy).",
                            children: [
                                {
                                    type: "name",
                                    title: "Type",
                                    content: "Sélectionner un type d'authentification pour votre réseau Wi-Fi. La valeur par défaut est <b>Auto</b>, qui choisi automatiquement <b>Système ouvert</b> ou <b>Clé partagée</b> est fonction des capacités et de la requête du client Wi-Fi."
                                }, {
                                    type: "name",
                                    title: "Clé sélectionnée ",
                                    content: "Sélectionner l'une des quatre clés."
                                }, {
                                    type: "name",
                                    title: "Format de clé WEP",
                                    content: "Utiliser le format <b>ASCII</b> ou <b>hexadécimal</b>. Le format ASCII est une combinaison de caractères alphanumériques. Le format hexadécimal est une combinaison de chiffres (0-9) et de lettres (A-F, a-f)."
                                }, {
                                    type: "name",
                                    title: "Type de clé ",
                                    content: "Choisir une longueur de clé WEP.",
                                    children: [
                                        {
                                            type: "name",
                                            title: "64 bits",
                                            content: "Vous permet de saisir 10 caractères hexadécimaux (0-9,A-F, a-f) ou 5 caractères ASCII dans le champ de mot de passe."
                                        }, {
                                            type: "name",
                                            title: "128 bits",
                                            content: "Vous permet de saisir 26 caractères hexadécimaux (0-9,A-F, a-f) ou 13 caractères ASCII dans le champ de mot de passe."
                                        }
                                    ]
                                }
                            ]
                        }
                    ]
                }, {
                    type: "name",
                    title: "Mode",
                    content: "Choisir un mode de transmission mixte."
                }, {
                    type: "name",
                    title: "Largeur de canal",
                    content: "Sélectionner une largeur de canal (largeur de bande) pour le réseau Wi-Fi correspondant."
                }, {
                    type: "name",
                    title: "Canal",
                    content: "Sélectionner un canal pour le réseau Wi-Fi correspondant. Il est recommandé de laisser le canal sur <b>Auto</b>, si vous ne constatez pas des connexions intermittentes."
                }, {
                    type: "name",
                    title: "Puissance d'émission",
                    content: "Sélectionner soit <b>Elevé</b>, soit <b>Moyen</b>, soit <b>bas</b> pour spécifier la puissance de transmission des données. Le paramètre par défaut et recommandé est <b>Elevé</b>."
                }, {
                    type: "paragraph",
                    content: "Cliquer sur <b>Sauvegarder</b> pour enregistrer tous vos paramètres."
                }
            ]
        },
        WIRELESS_24G: {
            TITLE: "Wi-Fi 2.4 GHz",
            CONTENT: [
                {
                    type: "name",
                    title: "Activer l'émission du Wi-Fi",
                    content: "Cocher cette case pour activer l'émission du signal Wi-Fi 2.4 GHz"
                }, {
                    type: "name",
                    title: "Nom de réseau (SSID)",
                    content: "Vous pouvez conserver le SSID par défaut ou en définir un nouveau (jusqu'à 32 caractères). Champ différenciant minuscules des majuscules."
                }, {
                    type: "name",
                    title: "Cacher le SSID",
                    content: "Cocher cette case si vous souhaitez ne pas diffuser le SSID du réseau 2.4 GHz."
                }, {
                    type: "name",
                    title: "Mot de passe",
                    content: "Générer un mot de passe comprenant 8 à 63 caractères ASCII, ou entre 8 et 64 caractères hexadécimaux (0-9, A-F, a-f) pour sécuriser ce réseau Wi-Fi."
                }, {
                    type: "name",
                    title: "Avancé",
                    content: "Cliquer pour afficher des paramètres plus détaillés."
                }, {
                    type: "name",
                    title: "Sécurité",
                    content: "Choisir l'une des options de sécurité suivantes :",
                    children: [
                        {
                            type: "name",
                            title: "Pas de sécurité",
                            content: "Sélectionner cette option pour désactiver la sécurisation du Wi-Fi. Il est <b>fortement recommandé</b> d'activer la sécurité Wi-Fi pour protéger votre réseau Wi-Fi de tout accès non autorisé."
                        }, {
                            type: "name",
                            title: "WPA/WPA2 Personnel",
                            content: "Sélectionner cette option pour activer une méthode d'authentification standard basée sur une clé PSK (Pre Shared Key), aussi appelée mot de passe. Cette option est recommandée. Si sélectionné, configurer.",
                            children: [
                                {
                                    type: "name",
                                    title: "Version",
                                    content: "Choisir une version de sécurité pour votre réseau Wi-Fi.",
                                    children: [
                                        {
                                            type: "name",
                                            title: "Auto",
                                            content: "Cette option supporte de multiples implémentations du standard WPA (Wi-Fi Protected Access) telles WPA et WPA2."
                                        }, {
                                            type: "name",
                                            title: "WPA-PSK",
                                            content: "Cette option supporte les chiffrements TKIP et AES."
                                        }, {
                                            type: "name",
                                            title: "WPA2-PSK",
                                            content: "Cette option supporte le chiffrement AES qui propose un meilleur niveau de sécurité que WPA-PSK et qui est donc recommandé."
                                        }
                                    ]
                                }, {
                                    type: "name",
                                    title: "Chiffrement",
                                    content: "Sélectionner le type de chiffrement : <b>TKIP</b> (Temporal Key Integrity Protocol), <b>AES</b> (Advanced Encryption Standard), ou <b>Auto</b> (combinant TKIP et AES). il n'<b>EST</b> pas recommandé d'utiliser le chiffrement TKIP si l'extenseur CPL utilise le standard 802.11n car ce chiffrement ne fait pas partie des spécifications 802.11n."
                                }
                            ]
                        }, {
                            type: "name",
                            title: "WEP",
                            content: "Sélectionner cette option pour activer une méthode d'authentification basique si l'un de vos clients Wi-Fi ne peut utiliser que WEP (Wired Equivalent Privacy).",
                            children: [
                                {
                                    type: "name",
                                    title: "Type",
                                    content: "Sélectionner un type d'authentification pour votre réseau Wi-Fi. La valeur par défaut est <b>Auto</b>, qui choisi automatiquement <b>Système ouvert</b> ou <b>Clé partagée</b> est fonction des capacités et de la requête du client Wi-Fi."
                                }, {
                                    type: "name",
                                    title: "Clé sélectionnée ",
                                    content: "Sélectionner l'une des quatre clés."
                                }, {
                                    type: "name",
                                    title: "Format de clé WEP",
                                    content: "Utiliser le format ASCII ou hexadécimal. Le format ASCII est une combinaison de caractères alphanumériques. Le format hexadécimal est une combinaison de chiffres (0-9) et de lettres (A-F, a-f)."
                                }, {
                                    type: "name",
                                    title: "Type de clé ",
                                    content: "Choisir une longueur de clé WEP.",
                                    children: [
                                        {
                                            type: "name",
                                            title: "64 bits",
                                            content: "Vous permet de saisir 10 caractères hexadécimaux (0-9,A-F, a-f) ou 5 caractères ASCII dans le champ de mot de passe."
                                        }, {
                                            type: "name",
                                            title: "128 bits",
                                            content: "Vous permet de saisir 26 caractères hexadécimaux (0-9,A-F, a-f) ou 13 caractères ASCII dans le champ de mot de passe."
                                        }
                                    ]
                                }
                            ]
                        }
                    ]
                }, {
                    type: "name",
                    title: "Mode",
                    content: "Choisir un mode de transmission mixte."
                }, {
                    type: "name",
                    title: "Largeur de canal",
                    content: "Sélectionner une largeur de canal (largeur de bande) pour le réseau Wi-Fi 2.4 GHz"
                }, {
                    type: "name",
                    title: "Canal",
                    content: "Sélectionner un canal pour le réseau Wi-Fi 2.4 GHz. Il est recommandé de laisser le canal sur <b>Auto</b>, si vous ne constatez pas des connexions intermittentes."
                }, {
                    type: "name",
                    title: "Puissance d'émission",
                    content: "Sélectionner soit <b>Elevé</b>, soit <b>Moyen</b>, soit <b>bas</b> pour spécifier la puissance de transmission des données. Le paramètre par défaut et recommandé est <b>Elevé</b>."
                }
            ]
        },
        WIRELESS_5G: {
            TITLE: "Wi-Fi 5 GHz",
            CONTENT: [
                {
                    type: "name",
                    title: "Activer l'émission du Wi-Fi",
                    content: "Cocher cette case pour activer l'émission du signal Wi-Fi 5 GHz"
                }, {
                    type: "name",
                    title: "Nom de réseau (SSID)",
                    content: "Vous pouvez laisser le nom de réseau (SSID) par défaut ou en créer un autre (de 32 caractères au maximum). Champ différenciant minuscules des majuscules."
                }, {
                    type: "name",
                    title: "Cacher le SSID",
                    content: "Cocher cette case si vous souhaitez ne pas diffuser le SSID du réseau 5 GHz."
                }, {
                    type: "name",
                    title: "Mot de passe",
                    content: "Générer un mot de passe comprenant 8 à 63 caractères ASCII, ou entre 8 et 64 caractères hexadécimaux (0-9, A-F, a-f) pour sécuriser ce réseau Wi-Fi."
                }, {
                    type: "name",
                    title: "Avancé",
                    content: "Cliquer pour afficher des paramètres plus détaillés."
                }, {
                    type: "name",
                    title: "Sécurité",
                    content: "Choisir l'une des options de sécurité suivantes :",
                    children: [
                        {
                            type: "name",
                            title: "Pas de sécurité",
                            content: "Sélectionner cette option pour désactiver la sécurisation du Wi-Fi. Il est <b>fortement recommandé</b> d'activer la sécurité Wi-Fi pour protéger votre réseau Wi-Fi de tout accès non autorisé."
                        }, {
                            type: "name",
                            title: "WPA/WPA2 Personnel",
                            content: "Sélectionner cette option pour activer une méthode d'authentification standard basée sur une clé PSK (Pre Shared Key), aussi appelée mot de passe. Cette option est recommandée. Si sélectionné, configurer.",
                            children: [
                                {
                                    type: "name",
                                    title: "Version",
                                    content: "Choisir une version de sécurité pour votre réseau Wi-Fi.",
                                    children: [
                                        {
                                            type: "name",
                                            title: "Auto",
                                            content: "Cette option supporte de multiples implémentations du standard WPA (Wi-Fi Protected Access) telles WPA et WPA2."
                                        }, {
                                            type: "name",
                                            title: "WPA-PSK",
                                            content: "Cette option supporte les chiffrements TKIP et AES."
                                        }, {
                                            type: "name",
                                            title: "WPA2-PSK",
                                            content: "Cette option supporte le chiffrement AES qui propose un meilleur niveau de sécurité que WPA-PSK et qui est donc recommandé."
                                        }
                                    ]
                                }, {
                                    type: "name",
                                    title: "Chiffrement",
                                    content: "Sélectionner le type de chiffrement : <b>TKIP</b> (Temporal Key Integrity Protocol), <b>AES</b> (Advanced Encryption Standard), ou <b>Auto</b> (combinant TKIP et AES). il n'<b>EST</b> pas recommandé d'utiliser le chiffrement TKIP si l'extenseur CPL utilise le standard 802.11n car ce chiffrement ne fait pas partie des spécifications 802.11n."
                                }
                            ]
                        }, {
                            type: "name",
                            title: "WEP",
                            content: "Sélectionner cette option pour activer une méthode d'authentification basique si l'un de vos clients Wi-Fi ne peut utiliser que WEP (Wired Equivalent Privacy).",
                            children: [
                                {
                                    type: "name",
                                    title: "Type",
                                    content: "Sélectionner un type d'authentification pour votre réseau Wi-Fi. La valeur par défaut est <b>Auto</b>, qui choisi automatiquement <b>Système ouvert</b> ou <b>Clé partagée</b> est fonction des capacités et de la requête du client Wi-Fi."
                                }, {
                                    type: "name",
                                    title: "Clé sélectionnée ",
                                    content: "Sélectionner l'une des quatre clés."
                                }, {
                                    type: "name",
                                    title: "Format de clé WEP",
                                    content: "Utiliser le format <b>ASCII</b> ou <b>hexadécimal</b>. Le format ASCII est une combinaison de caractères alphanumériques. Le format hexadécimal est une combinaison de chiffres (0-9) et de lettres (A-F, a-f)."
                                }, {
                                    type: "name",
                                    title: "Type de clé ",
                                    content: "Choisir une longueur de clé WEP.",
                                    children: [
                                        {
                                            type: "name",
                                            title: "64 bits",
                                            content: "Vous permet de saisir 10 caractères hexadécimaux (0-9,A-F, a-f) ou 5 caractères ASCII dans le champ de mot de passe."
                                        }, {
                                            type: "name",
                                            title: "128 bits",
                                            content: "Vous permet de saisir 26 caractères hexadécimaux (0-9,A-F, a-f) ou 13 caractères ASCII dans le champ de mot de passe."
                                        }
                                    ]
                                }
                            ]
                        }
                    ]
                }, {
                    type: "name",
                    title: "Mode",
                    content: "Choisir un mode de transmission mixte."
                }, {
                    type: "name",
                    title: "Largeur de canal",
                    content: "Sélectionner une largeur de canal (largeur de bande) pour le réseau Wi-Fi 5 GHz"
                }, {
                    type: "name",
                    title: "Canal",
                    content: "Sélectionner un canal pour le réseau Wi-Fi 5 GHz. Il est recommandé de laisser le canal sur Auto, si vous ne constatez pas des connexions intermittentes."
                }, {
                    type: "name",
                    title: "Puissance d'émission",
                    content: "Sélectionner soit Elevé, soit Moyen, soit Bas pour spécifier la puissance de transmission des données. Le paramètre par défaut et recommandé est \"Elevé\"."
                }, {
                    type: "paragraph",
                    content: "Cliquer sur Sauvegarder pour enregistrer tous vos paramètres."
                }
            ]
        },
        WIFI_TIME_CONTROL: {
            TITLE: "Programmation du Wi-Fi",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "La programmation Wi-Fi vous permet de définir des horaires spécifiques d'extinction du Wi-Fi."
                }, {
                    type: "name",
                    title: "Programmateur Wi-Fi",
                    content: "Basculer sur <b>On</b> pour activer la programmation du Wi-Fi. Si vous souhaitez que le réseau Wi-Fi soit maintenu tant qu'il y a des clients connectés, cocher cette case."
                }
            ]
        },
        WIFI_CLONE: {
            TITLE: "Clonage Wi-Fi",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "La fonction clonage Wi-Fi est utiliser pour recopier les paramètres Wi-Fi (SSID et mot de passe associé) de votre routeur principal sur votre extenseur."
                }, {
                    type: "name",
                    title: "Sélection de la bande Wi-Fi",
                    content: "Sélectionner l'un <span class=\"anti_5g\">ou les deux</span> à cloner.<span class=\"anti_5g\">Si le routeur principal ne supporte le clonage d'une seule bande à la fois, nous vous recommandons de choisir 2.4GHz & 5GHz ici pour être sûr que les bandes clonées correspondent aux bandes autorisées par votre routeur.</span>"
                }
            ]
        },
        WIFI_TIME_GRID: {
            TITLE: "Programmation d'extinction du Wi-Fi",
            CONTENT: [
                {
                    type: "name",
                    title: "De ",
                    content: "Indique l'heure à laquelle l'émission du signal Wi-Fi sera interrompue."
                }, {
                    type: "name",
                    title: "à",
                    content: "Affiche l'heure à laquelle le Wi-Fi est de nouveau actif."
                }, {
                    type: "name",
                    title: "Jour(s)",
                    content: "Affiche les jours concernés par la programmation."
                }, {
                    type: "name",
                    title: "Etat",
                    content: "Indique si la programmation est active ou non. Cliquer sur l'icône Ampoule pour activer (ou désactiver) la programmation."
                }, {
                    type: "name",
                    title: "Modifier",
                    content: "Indique les options pour <b>Modifier</b> ou <b>Supprimer</b> l'élément correspondant."
                }, {
                    type: "step",
                    title: "Pour ajouter une nouvelle programmation",
                    content: ["1. Cliquer sur <b>Ajouter</b>.", "2. Définir une plage horaire pendant laquelle le signal Wi-Fi ne sera pas émit.", "3. Sélectionner le(s) jour(s).", "4. Sélectionner <b>Activer cet élément</b>.", "5. Cliquer sur <b>OK</b> pour sauvegarder cet élément."]
                }, {
                    type: "paragraph",
                    content: "Pour modifier ou supprimer un élément Wi-Fi off, cliquer sur l'icône <b>Editer</b> pour éditer les informations ou sur l'icône <b>Poubelle</b> pour supprimer l'élément correspondant."
                }, {
                    type: "paragraph",
                    content: "Pour supprimer plusieurs programmations, sélectionner tous les éléments puis cliquer sur <b>Supprimer</b> au dessus de la liste."
                }
            ]
        },
        WPS: {
            TITLE: "Code PIN du routeur",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Les autres appareils peuvent se connecter à ce routeur à l'aide du code WPS du routeur."
                }, {
                    type: "name",
                    title: "Activer le code PIN du routeur",
                    content: "Basculer sur On pour autoriser les appareils Wi-Fi à se connecter au routeur à l'aide de son code PIN."
                }, {
                    type: "name",
                    title: "Code PIN du routeur",
                    content: "Indique le code PIN du routeur. Le code par défaut peut être trouvé sur l'étiquette du routeur ou dans le mode d'emploi. Cliquer sur générer pour créer un code aléatoire ou cliquer sur Par défaut pour restaurer le code paramétré en usine."
                }
            ]
        },
        WPS_WIZARD: {
            TITLE: "Assistant WPS",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Choisir une méthode de paramétrage"
                }, {
                    type: "name",
                    title: "Bouton WPS (recommandé)",
                    content: "Choisir cette méthode de configuration pour activer la fonction WPS afin de connecter aisément tout appareil compatible WPS à votre réseau Wi-Fi en utilisant le bouton WPS physique ou virtuel."
                }, {
                    type: "name",
                    title: "Code PIN",
                    content: "Sélectionner cette méthode de paramétrage pour ajouter manuellement un appareil en saisissant le code WPS de ce dernier dans le champ dédié puis en cliquant sur Se connecter."
                }
            ]
        },
        WIRELESS_STATISTICS: {
            TITLE: "Clients Wi-Fi connectés",
            CONTENT: [
                {
                    type: "name",
                    title: "Nombre de clients",
                    content: "Indique le nombre de clients Wi-Fi actuellement connectés au réseau CPL."
                }, {
                    type: "name",
                    title: "Nom d'appareil",
                    content: "Indique le nom du client Wi-Fi."
                }, {
                    type: "name",
                    title: "Adresse IP",
                    content: "Affiche l'adresse IP du client Wi-Fi."
                }, {
                    type: "name",
                    title: "Adresse MAC",
                    content: "Affiche l'adresse MAC du client Wi-Fi."
                }, {
                    type: "name",
                    title: "Bande Wi-Fi",
                    content: "Affiche la bande de fréquences <span class=\"anti_5g\">(2.4GHz or 5GHz) </span>du réseau auxquels les clients Wi-Fi sont connectés."
                }, {
                    type: "name",
                    title: "Sécurité",
                    content: "Indique le type de chiffrement du client Wi-Fi."
                }, {
                    type: "paragraph",
                    content: "Cliquer sur <b>Rafraichir</b> pour mettre à jour les informations affichées sur cette page."
                }
            ]
        },
        GUEST_NETWORK_BASIC: {
            TITLE: "Réseau invités",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "<b>Réseau invité</b> crée un réseau Wi-Fi distinct utilisable par vos invités pour leur offrir un accès internet."
                }
            ]
        },
        GUEST_NETWORK_SETTINGS: {
            TITLE: "Réseau invités",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "<b>Réseau invité</b> crée un réseau Wi-Fi distinct utilisable par vos invités pour leur offrir un accès internet."
                }, {
                    type: "name",
                    title: "Permet au invités de se voir mutuellement",
                    content: "Cocher cette case pour autoriser les appareils Wi-Fi à communiquer ensemble sur le réseau Wi-Fi invités."
                }, {
                    type: "name",
                    title: "Interdire aux invité d'administrer mon réseau",
                    content: "Sélectionner cette option pour interdire l'accès à l'interface Web d'administration aux invités."
                }, {
                    type: "name",
                    title: "Désactiver automatiquement après",
                    content: "Sélectionner cette option pour couper automatiquement le réseau invités aux horaires spécifiés."
                }, {
                    type: "paragraph",
                    content: "Cliquer sur <b>Sauvegarder</b> pour enregistrer tous vos paramètres."
                }
            ]
        },
        GUEST_NETWORK_WIRELESS: {
            TITLE: "Paramètres de réseau invité",
            CONTENT: [
                {
                    type: "name",
                    title: "2.4 GHz|5 GHz",
                    content: "Basculer entre 2.4 GHz et 5 GHz pour afficher leurs paramètres."
                }, {
                    type: "name",
                    title: "Activer le réseau invités",
                    content: "Cocher cette case pour activer le réseau invités."
                }, {
                    type: "name",
                    title: "Nom de réseau (SSID)",
                    content: "Utiliser le SSID invités par défaut ou saisir un nouveau nom (de 32 caractères au maximum)."
                }, {
                    type: "name",
                    title: "Sécurité",
                    content: "Choisir l'une des options de sécurité suivantes :",
                    children: [
                        {
                            type: "name",
                            title: "Pas de sécurité",
                            content: "Sélectionner cette option pour désactiver la sécurisation du Wi-Fi. Il est <b>fortement recommandé</b> d'activer la sécurité Wi-Fi pour protéger votre réseau Wi-Fi invités de tout accès non autorisé."
                        }, {
                            type: "name",
                            title: "WPA/WPA2 Personnel",
                            content: "Sélectionner cette option pour activer une méthode d'authentification standard basée sur une clé PSK (Pre Shared Key), aussi appelée mot de passe. Si sélectionné, configurer les éléments suivants :"
                        }
                    ]
                }, {
                    type: "name",
                    title: "Mot de passe",
                    content: "Utiliser le mot de passe par défaut ou générer un mot de passe comprenant 8 à 63 caractères ASCII ou 8 à 64 caractères hexadécimaux (0-9, A-F, a-f)"
                }, {
                    type: "paragraph",
                    content: "Cliquer sur <b>Sauvegarder</b> pour enregistrer vos paramètres de réseau Wi-Fi invités."
                }
            ]
        },
        GUEST_NETWORK_WIRELESS_2G: {
            TITLE: "Paramètres Wi-Fi",
            CONTENT: [
                {
                    type: "name",
                    title: "Activer le réseau invités",
                    content: "Cocher cette case pour activer le réseau invités."
                }, {
                    type: "name",
                    title: "Nom de réseau (SSID)",
                    content: "Utiliser le SSID invités par défaut ou saisir un nouveau nom (de 32 caractères au maximum)."
                }, {
                    type: "name",
                    title: "Sécurité",
                    content: "Choisir l'une des options de sécurité suivantes :",
                    children: [
                        {
                            type: "name",
                            title: "Pas de sécurité",
                            content: "Sélectionner cette option pour désactiver la sécurisation du Wi-Fi. Il est <b>fortement recommandé</b> d'activer la sécurité Wi-Fi pour protéger votre réseau Wi-Fi invités de tout accès non autorisé."
                        }, {
                            type: "name",
                            title: "WPA/WPA2 Personnel",
                            content: "Sélectionner cette option pour activer une méthode d'authentification standard basée sur une clé PSK (Pre Shared Key), aussi appelée mot de passe. Si sélectionné, configurer les éléments suivants :"
                        }
                    ]
                }, {
                    type: "name",
                    title: "Mot de passe",
                    content: "Utiliser le mot de passe par défaut ou générer un mot de passe comprenant 8 à 63 caractères ASCII ou 8 à 64 caractères hexadécimaux (0-9, A-F, a-f)"
                }, {
                    type: "paragraph",
                    content: "Cliquer sur <b>Sauvegarder</b> pour enregistrer vos paramètres de réseau Wi-Fi invités."
                }
            ]
        },
        NAT: {
            TITLE: "Passerelle de couche applicative (ALG)",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "ALG permet de faciliter la traversée du NAT (Network Address Translation) pour certains protocoles applicatifs tels que : FTP, TFPT, H323 etc. Activer ALG est recommandé."
                }, {
                    type: "name",
                    title: "Activer FTP ALG",
                    content: "Si coché, cela autorise les clients et serveurs FTP (File Transfert Protocole) à transférer des données via le NAT."
                }, {
                    type: "name",
                    title: "Activer TFTP ALG",
                    content: "Si coché, cela autorise les clients et serveurs TFTP (Trivial File Transfert Protocole) à transférer des données via le NAT."
                }, {
                    type: "name",
                    title: "Activer H323 ALG",
                    content: "Si sélectionné, les clients Microsoft Netmeeting peuvent communiquer via le NAT."
                }, {
                    type: "name",
                    title: "Activer RTSP ALG",
                    content: "Si sélectionné, les diffuseur de médias sont autorisés à communiquer avec les serveurs de médias via le NAT."
                }, {
                    type: "name",
                    title: "Activer la traversée PPTP",
                    content: "Si sélectionné, des sessions PTP peuvent être encapsulées et traverser le routeur."
                }, {
                    type: "name",
                    title: "Activer la traversée L2TP",
                    content: "Si sélectionné, des sessions L2TP peuvent être encapsulées et traverser le routeur."
                }, {
                    type: "name",
                    title: "Activer la traversée IPSec",
                    content: "Si sélectionné, un réseau IP peut être encapsulé et traverser le routeur grâce au protocole IPSec (Internet Protocol Security). IPSec utilise des services de sécurité cryptographiques pour garantir la confidentialité et la sécurité des communications via les réseaux IP."
                }, {
                    type: "paragraph",
                    content: "Cliquer sur Sauvegarder pour enregistrer tous vos paramètres."
                }
            ]
        },
        VIRTUAL_SERVERS: {
            TITLE: "Serveurs virtuels",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Les serveurs virtuels sont utilisés pour paramétrer des services accessibles sur votre réseau local. Un serveur virtuel est défini comme port externe, toutes les requêtes vers ce port depuis internet seront redirigées vers l'ordinateur désigné qui doit être configuré avec une adresse IP fixe ou réservée."
                }, {
                    type: "name",
                    title: "Type de service",
                    content: "Indique le nom de votre serveur virtuel."
                }, {
                    type: "name",
                    title: "Port externe",
                    content: "Indique le n° de port ou la plage de N° de port utilisée par le serveur virtuel"
                }, {
                    type: "name",
                    title: "IP interne",
                    content: "Indique l'adresse IP de l'ordinateur exécutant l'application service."
                }, {
                    type: "name",
                    title: "Port interne",
                    content: "Indique le numéro de port de l'ordinateur exécutant l'application service."
                }, {
                    type: "name",
                    title: "Protocole",
                    content: "Indique le protocole utilisé pour l'application service : TCP, UDP, ou Tout (Tous les protocoles supportés par le routeur)."
                }, {
                    type: "name",
                    title: "Etat",
                    content: "Affiche l'état actuel (actif ou inactif) de la règle de filtrage spécifiée"
                }, {
                    type: "name",
                    title: "Modifier",
                    content: "Indiques les options pour Modifier ou Supprimer la règle correspondante."
                }, {
                    type: "step",
                    title: "Pour paramétrer un serveur virtuel",
                    content: ["1. Cliquer sur Ajouter.", "2. Cliquer sur Voir les Services paramétrés pour sélectionner un service dans liste et remplir automatiquement les valeurs requises dans les champs Numéro de port interne/externe. Si le service n'est pas listé, saisir le numéro de port externe (exemple 21) ou une plage de ports (exemple 21-25). Laisser le champ port interne vierge s'il est identique au port externe ou saisir la valeur requise (par ex. 21) si le port externe est unique. Saisie l'adresse IP de l'ordinateur hébergeant l'application en respectant le format décimal pointé xxx.xxx.xxx.xxx.", "3. Sélectionner depuis la liste déroulante, un protocole pour l'application : TCP, UDP ou Tous.", "4. Sélectionner Activer.", "5. Cliquer sur OK."]
                }, {
                    type: "step",
                    title: "Pour modifier ou effacer un serveur virtuel",
                    content: "Cliquer sur l'icône Modifier ou Supprimer correspondant à la règle que vous souhaitez modifier ou supprimer."
                }, {
                    type: "step",
                    title: "Pour effacer plusieurs règles",
                    content: "Sélectionner tous les éléments que vous souhaitez supprimer, cliquer sur Supprimer au dessus de la liste."
                }, {
                    type: "note",
                    title: "Remarque",
                    content: "Si votre serveur local héberge plusieurs type de services, vous devez créer une règle pour chacun d'eux."
                }
            ]
        },
        PORT_TRIGGERING: {
            TITLE: "Déclenchement par port",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Le déclenchement par port est utilisé pour transférer le trafic depuis un port défini vers un serveur spécifique sur le réseau local."
                }, {
                    type: "name",
                    title: "Application",
                    content: "Indique le nom de l'application"
                }, {
                    type: "name",
                    title: "Port de déclenchement",
                    content: "Indique le port de trafic sortant utilisé pour déclencher une règle de filtrage d'une connexion sortante."
                }, {
                    type: "name",
                    title: "Protocole de déclenchement",
                    content: "Indique le protocole utilisé pour le port déclencheur : TCP, UDP ou Tous (Tous les protocoles supportés par le routeur)."
                }, {
                    type: "name",
                    title: "Port externe",
                    content: "Indique le n° de port ou la plage de N° de port utilisée par le système distant. Une réponse utilisant l'un de ses ports sera transmise à l'adresse IP qui déclenche cette règle. Vous pouvez saisir au maximum 5 plages de ports (qui peuvent ne comporter qu'un seul port). Chaque plage de port doit être séparée par une virgule, par exemple : 2000-2038,2046,2050-2051,2085,3010-3030."
                }, {
                    type: "name",
                    title: "Protocole externe",
                    content: "Indique le protocole utilisé pour le port entrant : TCP, UDP ou Tous (Tous les protocoles supportés par le routeur)."
                }, {
                    type: "name",
                    title: "Etat",
                    content: "Affiche l'état actuel (actif ou inactif) de la règle de filtrage spécifiée"
                }, {
                    type: "name",
                    title: "Modifier",
                    content: "Affiche les options pour Modifier ou Supprimer la règle correspondante."
                }, {
                    type: "step",
                    title: "Pour définir une règle de déclenchement par port",
                    content: [
                        {
                            type: "note",
                            title: "Remarque",
                            content: "Chaque règle ne peut être appliqué qu'à un hôte à la fois."
                        },
                        "1. Cliquer sur Ajouter.", {
                            content: "2. Cliquer sur Applications paramétrées pour sélectionner l'une d'entre elles dans la liste et remplir automatiquement les champs avec les valeurs adéquates. Si vous souhaitez ajouter une application non listée, saisir son nom, le port et le protocole déclencheur ainsi que le port et le protocole externe.",
                            children: [
                                {
                                    type: "note",
                                    title: "Remarque",
                                    content: "Aucune règle ne peut avoir de plage de port commune avec une autre règle (Ex : la règle 1 utilise les ports 4200 à 4025 ; la règle 2 ne peut utiliser les ports 4203 à 4206)."
                                }
                            ]
                        },
                        "3. Sélectionner activer.",
                        "4. Cliquer sur OK."
                    ]
                }, {
                    type: "step",
                    title: "Pour modifier ou effacer une règle de déclenchement par port",
                    content: "Dans la liste, cliquer sur l'icône Editer ou Poubelle qui correspond à la règle que vous souhaitez modifier ou supprimer."
                }, {
                    type: "step",
                    title: "Pour effacer plusieurs règles de déclenchement par port",
                    content: "Dans la liste , sélectionner toutes les règles que vous souhaitez supprimer et cliquer sur Supprimer au dessus de la liste."
                }
            ]
        },
        DMZ: {
            TITLE: "DMZ",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "La DMZ (Zone Démilitarisée) permet l'exposition d'un hôte local depuis internet pour des besoins spécifiques, tels que de la vidéoconférence ou du jeu en ligne. Fondamentalement, la DMZ permet d'ouvrir tous les ports d'un ordinateur présent sur le réseau local. Cet ordinateur doit être configuré avec une adresse IP fixe : désactiver l'obtention des paramètres depuis un serveur DHCP."
                }, {
                    type: "step",
                    title: "Pour définir un ordinateur ou un serveur comme serveur DMZ",
                    content: ["1. Cliquer sur activer DMZ.", "2. Dans le champ Adresse IP de l'hôte DMZ, saisir l'adresse IP d'un ordinateur du réseau local qui sera défini comme l'hôte DMZ.", "3. Cliquer sur Sauvegarder."]
                }
            ]
        },
        UPNP: {
            TITLE: "UPnP",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Par défaut, la fonction UPnP (Universal Plug and Play) est activée pour que les appareils tels que les ordinateurs et les appareils connectés se découvrent automatiquement et communiquent entre eux sur le réseau local."
                }, {
                    type: "paragraph",
                    content: "La liste de services UPnP Indique les informations des appareils UPnP"
                }, {
                    type: "name",
                    title: "Description du service",
                    content: "Indique une brève description de l'hôte local qui émet des requêtes UPnP"
                }, {
                    type: "name",
                    title: "Port externe",
                    content: "Indique le port externe ouvert par l'hôte local."
                }, {
                    type: "name",
                    title: "Protocole",
                    content: "Indique le type de protocole utilisé par l'hôte local."
                }, {
                    type: "name",
                    title: "Adresse IP interne",
                    content: "Indique l'adresse IP de l'hôte local."
                }, {
                    type: "name",
                    title: "Port interne",
                    content: "Indique le port interne ouvert par l'hôte local."
                }, {
                    type: "paragraph",
                    content: "Cliquer sur Rafraichir pour mettre à jour la liste de serveurs UPnP."
                }
            ]
        },
        DISK_SETTING: {
            TITLE: "Paramètres d'appareil",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "La page des paramètres d'appareil indique les informations relatives aux périphériques USB connectés au routeur."
                }, {
                    type: "name",
                    title: "Rechercher",
                    content: "Normalement le routeur détecte automatiquement tout nouvel appareil connecté. Sinon, cliquer sur ce bouton pour détecter tout nouvel appareil et mettre à jour le contenu de cette page."
                }, {
                    type: "name",
                    title: "Volume",
                    content: "Indique le nom du volume USB."
                }, {
                    type: "name",
                    title: "Capacité",
                    content: "Indique la capacité de stockage disponible du périphérique USB."
                }, {
                    type: "name",
                    title: "Espace libre",
                    content: "Indique la capacité de stockage disponible du périphérique USB."
                }, {
                    type: "name",
                    title: "Ejecter sans risque",
                    content: "Cliquer sur ce bouton pour déconnecter proprement, le périphérique de stockage USB avant de le débrancher du routeur."
                }, {
                    type: "paragraph",
                    content: "Gardez en mémoire que le bouton d'éjection n'apparait qu'en présence d'un périphérique de stockage USB connecté au routeur, et que vous ne pouvez éjecter ce périphérique tant qu'il y est occupé par un transfert."
                }, {
                    type: "name",
                    title: "Actif",
                    content: "Cette case à cocher n'appareil que lorsqu'un périphérique de stockage USB est connecté au routeur. Sélectionner pour activer le partage de fichier depuis le périphérique USB."
                }, {
                    type: "step",
                    title: "Pour configurer un serveur de fichiers",
                    content: ["1. Connectez le périphérique de stockage USB à l'aide d'un cordon au routeur.", "2. Le périphérique USB qui vient d'être connecté doit être automatiquement détecté par le routeur qui en affiche les informations dans la section Paramètres d'appareil. Sinon, cliquer sur détecter.", "3. Sélectionner Activer pour activer le partage de fichiers."]
                }
            ]
        },
        FOLDER_SHARE_ACCOUNT: {
            TITLE: "Compte de partage",
            CONTENT: [
                {
                    type: "name",
                    title: "Compte",
                    content: "Vous pouvez choisir d'utiliser le compte par défaut pour l'accès aux dossiers et fichiers partagés ou Définir un nouveau compte et saisir les paramètres de ce nouveau compte."
                }, {
                    type: "name",
                    title: "Nom d'utilisateur / Mot de passe",
                    content: "Saisir une chaine de caractères alphanumériques de 15 caractères maximum. Le nom d'utilisateur doit commencer par une lettre. Ces champs différencient majuscules et minuscules."
                }, {
                    type: "name",
                    title: "Confirmer le mot de passe",
                    content: "Ressaisir le mot de passe pour le confirmer. Ce champ différencie aussi minuscules et majuscules"
                }, {
                    type: "paragraph",
                    content: "Cliquer sur Sauvegarder pour enregistrer le nouveau compte utilisateur."
                }
            ]
        },
        FOLDER_SHARE_SETTINGS: {
            TITLE: "Paramètres de partage",
            CONTENT: [
                {
                    type: "name",
                    title: "Nom du réseau / Serveur de médias",
                    content: "Indique le nom utilisé pour accéder au périphérique de stockage USB."
                }, {
                    type: "name",
                    title: "Activer",
                    content: "Sélectionner pour activer la méthode d'accès."
                }, {
                    type: "name",
                    title: "Méthode d'accès",
                    content: "Il existe trois méthodes d'accès au périphérique de stockage USB connecté. Vous pouvez choisir une ou plusieurs méthodes d'accès en cochant les cases correspondantes.",
                    children: [
                        {
                            type: "name",
                            title: "Voisinage réseau",
                            content: "Si activé les utilisateurs de votre réseau peuvent accéder au périphérique de stockage USB par l'adresse IP assignée (ex : \\\\192.168.0.1) au routeur. Cette méthode est activée par défaut."
                        }, {
                            type: "name",
                            title: "FTP",
                            content: "Si activé, les clients FTP de votre réseau local peuvent accéder au périphérique de stockage USB via l'adresse IP du routeur suivie du port du serveur FTP (ex: ftp://192.168.0.1:21)."
                        }, {
                            type: "name",
                            title: "FTP (Accès via internet)",
                            content: "Si activé, les utilisateurs peuvent accéder en FTP via internet au périphérique de stockage USB. Cette fonction supporte le téléchargement et le téléversement de fichiers. Pour modifier le port du serveur FTP saisir un numéro de port et cliquer sur sauvegarder pour activer les modifications."
                        }
                    ]
                }, {
                    type: "name",
                    title: "Lien",
                    content: "Indique les adresses utilisables pour accéder aux périphériques de stockage USB partagés."
                }, {
                    type: "name",
                    title: "Port",
                    content: "Indique le port FTP du serveur FTP."
                }
            ]
        },
        FOLDER_SHARE_FOLDERS: {
            TITLE: "Partage de répertoire",
            CONTENT: [
                {
                    type: "name",
                    title: "Tout partager",
                    content: "Basculer sur Actif pour partager tous les fichiers et dossiers ou sur Inactif pour ne partager que les dossiers sélectionnés."
                }, {
                    type: "name",
                    title: "Activer l'authentification",
                    content: "Il est fortement conseillé de d'activer l'authentification pour imposer la saisie d'un nom d'utilisateur et d'un mot de passe pour accéder aux dossiers partagés."
                }, {
                    type: "name",
                    title: "Nom du répertoire",
                    content: "Indique le nom du dossier partagé."
                }, {
                    type: "name",
                    title: "Chemin du répertoire",
                    content: "Indique le chemin du répertoire partagé."
                }, {
                    type: "name",
                    title: "Partage de médias",
                    content: "Indique si le dossier partagé est autorisé pour le partage de médias ou non."
                }, {
                    type: "name",
                    title: "Nom de volume",
                    content: "Indique le nom du volume partagé."
                }, {
                    type: "name",
                    title: "Etat",
                    content: "Indique l'état du répertoire partagé par l'indicateur en forme d'ampoule. Vert (On) est actif et Gris (Off) est inactif. Vous pouvez activer ou désactiver le partage en cliquant sur l'icone ampoule."
                }, {
                    type: "name",
                    title: "Modifier",
                    content: "Affiche les options pour Modifier ou Supprimer le dossier partagé correspondant."
                }, {
                    type: "name",
                    title: "Naviguer",
                    content: "Cliquer pour rechercher un dossier de partage."
                }, {
                    type: "name",
                    title: "Permettre l'accès réseau aux invités",
                    content: "Sélectionner pour autoriser l'accès aux dossiers partagés aux clients du réseau invités."
                }, {
                    type: "name",
                    title: "Activer l'authentification",
                    content: "Sélectionner pour demander un nom d'utilisateur et un mot de passe aux utilisateurs pour accéder au dossiers partagés."
                }, {
                    type: "name",
                    title: "Activer l'accès en écriture",
                    content: "Sélectionner pour permettre aux utilisateurs de modifier le contenu du dossier."
                }, {
                    type: "name",
                    title: "Activer le partage de médias",
                    content: "Sélectionner pour activer le partage de dossier."
                }
            ]
        },
        PRINT_SERVER: {
            TITLE: "Serveur d'impression",
            CONTENT: [
                {
                    type: "step",
                    title: "Pour paramétrer un serveur d'impression dans votre réseau local",
                    content: ["1. Connecter une imprimante USB à l'aide d'un cordon au routeur.", "2. Installer les pilotes de l'imprimante sur votre ordinateur Se référer au mode d'emploi de l'ordinateur pour les instructions.", "3. Installer le contrôleur d'impression USB TP-Link soit depuis le CD (Windows) soit téléchargé (Windows, Mac OS X) depuis le site de TP-Link."]
                }
            ]
        },
        PARENTAL_CONTROL: {
            TITLE: "Contrôle parental",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Avec le contrôle parental, vous pouvez définir des plages horaires pour contrôler et limiter l'accès à internet aux clients Wi-Fi concernés."
                }, {
                    type: "name",
                    title: "Contrôle parental",
                    content: "Basculer sur <b>On</b> pour activer le contrôle parental."
                }
            ]
        },
        PARENTAL_CONTROL_DEVICES: {
            TITLE: "Appareils soumis au contrôle parental",
            CONTENT: [
                {
                    type: "name",
                    title: "ID",
                    content: "Affiche le N° de l'appareil client."
                }, {
                    type: "name",
                    title: "Adresse MAC",
                    content: "Affiche l'adresse MAC de l'appareil client."
                }, {
                    type: "name",
                    title: "Horaire d'accès à internet",
                    content: "Indique les plages horaires d'accès."
                }, {
                    type: "name",
                    title: "Description",
                    content: "Affiche une brève description de l'appareil connecté."
                }, {
                    type: "name",
                    title: "Etat",
                    content: "Indique si le contrôle parental est activé pour l'appareil correspondant."
                }, {
                    type: "name",
                    title: "Modifier",
                    content: "Affiche les options pour<b>Modifier</b> ou <b>Supprimer</b> l'appareil."
                }, {
                    type: "step",
                    title: "Pour définir les limites horaires d'un nouvel appareil client",
                    content: [
                        "1. Cliquer sur <b>Ajouter</b>.",
                        "2. Cliquer sur <b>Voir les appareils connectés</b> et choisir un appareil de la liste <b>Appareils Wi-Fi</b> ou, saisir l'adresse MAC d'un appareil non connecté manuellement.",
                        "3. Cliquer sur l'icône <b>Horaires d'accès à internet</b> pour spécifier les plages horaires pendant lesquels les appareils pourront accéder à internet.",
                        "4. Saisir une brève description dans le champ <b>Description</b>. Ce champ est optionnel.",
                        "5. Sélectionner <b>Activer cet élément</b>.",
                        "6. Cliquer sur <b>OK</b> pour sauvegarder cet élément."
                    ]
                }, {
                    type: "paragraph",
                    content: "Pour modifier ou supprimer un appareil de la liste, cliquer sur l'icône <b>Editer</b> pour éditer les informations ou sur l'icône <b>Poubelle</b> pour supprimer l'élément correspondant."
                }, {
                    type: "paragraph",
                    content: "Pour supprimer plusieurs appareils de la liste, cocher la case correspondant aux appareils à supprimer et cliquer sur <b>Supprimer</b> au dessus de la liste."
                }
            ]
        },
        PARENTAL_CONTROL_RESTRICTION: {
            TITLE: "Restrictions de contenu",
            CONTENT: [
                {
                    type: "name",
                    title: "Liste noire",
                    content: "Contient des mots clés qui seront utilisés pour bloquer l'accès à des sites Web pour les clients spécifiés dans la liste soumise au contrôle parental.",
                    children: [
                        {
                            type: "paragraph",
                            content: "Cliquer sur ajouter un nouveau mot clé pour ajouter celui-ci à la liste noire. Pour supprimer un mot clé, cliquer sur l'icône (-) du mot clé que vous souhaitez supprimer."
                        }
                    ]
                }, {
                    type: "name",
                    title: "liste blanche",
                    content: "Contient des adresses de sites Web auxquels les clients spécifiés dans la liste soumise au contrôle parental ne pourront pas accéder.",
                    children: [
                        {
                            type: "paragraph",
                            content: "Cliquer sur ajouter un nouveau nom de domaine pour ajouter un site à la liste blanche. Pour supprimer un site Web, cliquer sur l'icône (-) du site Web que vous souhaitez supprimer."
                        }
                    ]
                }, {
                    type: "note",
                    title: "Remarque",
                    content: "Les mots clés peuvent aussi être des nom de domaine tel que : www.gmail.com ou www.facebook.com"
                }, {
                    type: "paragraph",
                    content: "Cliquer sur Sauvegarder pour enregistrer votre configuration."
                }
            ]
        },
        QOS: {
            TITLE: "QoS",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "La QoS (Quality Of Service) Aide à catégoriser le trafic internet en fonction de vos besoins. Vous pouvez spécifier le niveau de priorité pour un appareil ou une application dans la liste des règles de QoS."
                }, {
                    type: "note",
                    title: "Remarque",
                    content: "Si le NAT Boost est activé, la QoS doit être désactivée."
                }, {
                    type: "name",
                    title: "Activer la QoS",
                    content: "Cocher cette case pour activer la fonction QoS."
                }, {
                    type: "name",
                    title: "Bande passante de téléversement",
                    content: "Saisir le débit montant maximal (upload) fourni par votre FAI."
                }, {
                    type: "name",
                    title: "Bande passante de téléchargement",
                    content: "Saisir le débit descendant maximal (download) fourni par votre FAI."
                }, {
                    type: "name",
                    title: "Priorité haute garantie",
                    content: "Spécifier un pourcentage pour le trafic à priorité élevée."
                }, {
                    type: "name",
                    title: "Priorité moyenne garantie",
                    content: "Spécifier un pourcentage pour le trafic à priorité Moyenne."
                }, {
                    type: "name",
                    title: "Priorité basse garantie",
                    content: "Spécifier un pourcentage pour le trafic à priorité basse."
                }, {
                    type: "note",
                    title: "Remarque",
                    content: "Le pourcentage cumulé de priorités ne peut excéder 100%."
                }, {
                    type: "paragraph",
                    content: "Cliquer sur Sauvegarder pour enregistrer tous vos paramètres."
                }
            ]
        },
        QOS_RULE: {
            TITLE: "Liste de règles de QoS",
            CONTENT: [
                {
                    type: "name",
                    title: "Type",
                    content: "Sélectionner un type pour ajouter la liste de règle de QoS."
                }, {
                    type: "step",
                    title: "Pour paramétrer une priorité basse/moyenne/haute par appareil",
                    content: ["1. Cliquer sur Ajouter.", "2. Sélectionner Par appareil.", "3. Cliquer sur Voir les appareils pour choisir l'appareil voulu dans la liste ou bien saisir son nom et son adresse MAC dans les champs dédiés.", "4. Cliquer sur OK."]
                }, {
                    type: "step",
                    title: "Pour paramétrer une priorité basse/moyenne/haute par application",
                    content: ["1. Cliquer sur Ajouter.", "2. Sélectionner Par application.", "3. Sélectionner l'application depuis la liste des applications, ou personnalisez une application en complétant les champs Nom, Protocole et Port.", "4. Cliquer sur OK."]
                }, {
                    type: "step",
                    title: "Pour définir une règle de priorité Haute/Moyenne/Basse par port physique.",
                    content: ["1. Cliquer sur Ajouter.", "2. Sélectionner Par port physique.", "3. Sélectionner le port de votre choix.", "4. Cliquer sur OK."]
                }
            ]
        },
        QOS_DATABASE: {
            TITLE: "Mise à jour de la base de données",
            CONTENT: [
                {
                    type: "name",
                    title: "Nouveau fichier de base de données",
                    content: "Cliquer sur Naviguer pour rechercher le nouveau fichier de base de données. Sélectionner et cliquer sur Mettre à jour pour mettre la base de données."
                }, {
                    type: "name",
                    title: "Version de la base de données",
                    content: "Affiche la version de la base de donnée actuelle."
                }
            ]
        },
        SECURITY_FIREWALL: {
            TITLE: "Pare-feu",
            CONTENT: [
                {
                    type: "name",
                    title: "Pare-feu SPI",
                    content: "Le pare-feu SPI (Stateful Packet Inspection) empêche les cyber attaques et valide le trafic traversant le routeur en fonction du protocole. Le pare-feu SPI est activé par défaut."
                }
            ]
        },
        SECURITY_DOS: {
            TITLE: "Protection DoS",
            CONTENT: [
                {
                    type: "name",
                    title: "Protection DoS",
                    content: "La protection contre les dénis de service (DoS) protège votre réseau contre les attaques DoS qui l'inondent de requêtes. Par défaut, la protection DoS est désactivée (Off)."
                }, {
                    type: "name",
                    title: "Filtrage d'attaques ICMP-Flood",
                    content: "Activer pour empêcher les attaques par saturation ICMP (Internet Control Message Protocol)."
                }, {
                    type: "name",
                    title: "Filtrage d'attaques UDP-Flood",
                    content: "Activer pour empêcher les attaques par saturation UDP (User Datagram Protocol)."
                }, {
                    type: "name",
                    title: "Niveau de paquets TCP-SYN-FLOOD",
                    content: "Activer pour empêcher les attaques par saturation TCP-SYN (Transmission Control Protocol-Synchronize).",
                    children: [
                        {
                            type: "name",
                            title: "Désactivé",
                            content: "Aucune protection."
                        }, {
                            type: "name",
                            title: "BAS",
                            content: "Faible protection et faible impact sur les performances du routeur."
                        }, {
                            type: "name",
                            title: "Moyen(ne)",
                            content: "Niveau de protection moyen et impact modéré sur les performances du routeur."
                        }, {
                            type: "name",
                            title: "Elevé(e)",
                            content: "Haut niveau de protection mais impact notable sur les performances du routeur."
                        }
                    ]
                }, {
                    type: "name",
                    title: "Ignorer le Ping depuis le port WAN",
                    content: "Activer pour ignorer le Ping depuis le port WAN."
                }, {
                    type: "name",
                    title: "Interdire le Ping depuis le LAN",
                    content: "Activer pour interdire le Ping depuis le port LAN."
                }
            ]
        },
        MAC_FILTER_ALL: {
            TITLE: "Filtrage par adresse MAC",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Le filtrage par adresses MAX est utilisé pour autoriser ou bloquer les appareils spécifiés à accéder à votre réseau. Quand un appareil est bloqué, il ne peut se connecter au CPL."
                }, {
                    type: "name",
                    title: "Paramètres de filtrage d'adresses MAC",
                    children: [
                        {
                            type: "name",
                            title: "Filtrage par adresse MAC",
                            content: "Basculer sur <b>On</b> pour activer cette fonction. Si la fonction est désactivée (Off) tous les appareils sont autorisés à se connecter."
                        }
                    ]
                }, {
                    type: "name",
                    title: "Sélectionner la liste de filtrage",
                    content: "Sélectionner pour Bloquer ou Autoriser les appareils clients de la liste à accéder au réseau Wi-Fi. Cliquer sur <b>Sauvegarder</b> pour enregistrer vos réglages."
                }, {
                    type: "name",
                    title: "Liste d'appareils",
                    children: [
                        {
                            type: "step",
                            title: "Pour ajouter un appareil client"
                        }, {
                            type: "step",
                            title: "Pour modifier ou supprimer un appareil client",
                            content: "Cliquer sur l'icone <b>Editer</b> ou <b>Supprimer</b> correspondant à l'appareil que vous souhaitez modifier ou supprimer."
                        }, {
                            type: "step",
                            title: "Pour supprimer plusieurs appareils de la liste",
                            content: "Cocher la case correspondant à l'appareil à effacer, et cliquer sur <b>Effacer</b> au dessus du tableau."
                        }
                    ]
                }
            ]
        },
        MAC_FILTER: {
            TITLE: "Filtrage par adresse MAC",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Le filtrage par adresses MAX est utilisé pour autoriser ou bloquer les appareils spécifiés à accéder à votre réseau. Quand un appareil est bloqué, il ne peut se connecter au CPL."
                }, {
                    type: "name",
                    title: "Paramètres de filtrage d'adresses MAC",
                    children: [
                        {
                            type: "name",
                            title: "Filtrage par adresse MAC",
                            content: "Basculer sur <b>On</b> pour activer cette fonction. Si la fonction est désactivée (Off) tous les appareils sont autorisés à se connecter."
                        }
                    ]
                }
            ]
        },
        MAC_FILTER_RULES: {
            TITLE: "Sélectionner la liste de filtrage",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Sélectionner pour Bloquer ou Autoriser les appareils clients de la liste à accéder au réseau Wi-Fi."
                }, {
                    type: "paragraph",
                    content: "Cliquer sur <b>Sauvegarder</b> pour enregistrer vos paramètres."
                }
            ]
        },
        MAC_FILTER_DEVICE_LIST: {
            TITLE: "Liste d'appareils",
            CONTENT: [
                {
                    type: "step",
                    title: "Pour ajouter un appareil client",
                    content: ["1. Cliquer sur <b>Ajouter</b>.", "2. Cliquer sur <b>Voir les appareils</b> et choisir l'adresse MAC de l'appareil dans la liste ou, saisir l'adresse MAC manuellement.", "3. Faire une brève description de l'appareil.", "4. Sélectionner <b>Activer cet élément</b>.", "5. Cliquer sur <b>OK</b>."]
                }, {
                    type: "step",
                    title: "Pour modifier ou supprimer un appareil de la liste",
                    content: "Cliquer sur l'icone <b>Editer</b> ou <b>Supprimer</b> correspondant à l'appareil que vous souhaitez modifier ou supprimer."
                }, {
                    type: "step",
                    title: "Pour supprimer plusieurs appareils de la liste",
                    content: "Cocher la case correspondant à l'appareil à effacer, et cliquer sur <b>Effacer</b> au dessus du tableau."
                }
            ]
        },
        WIFI_MOVE: {
            TITLE: "Wi-Fi move",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Quand la fonction Wi-Fi Move est activée, tout changement opéré sur les paramètres Wi-Fi sont automatiquement répliqués aux extenseurs CPL ayant activé la fonction Wi-Fi Move. Notez que si le nom par défaut : HomePlugAV est utilisé, la fonction Wi-Fi Move est automatiquement désactivée."
                }, {
                    type: "name",
                    title: "Wi-Fi move",
                    content: "Basculer sur <b>On</b> pour activer cette fonction."
                }
            ]
        },
        SECURITY_LIST: {
            TITLE: "Liste des hôtes DoS bloqués",
            CONTENT: [
                {
                    type: "name",
                    title: "Liste des hôtes DoS bloqués",
                    content: "Liste les adresses IP et MAX de toute source d'attaque par DoS ayant été bloquée."
                }, {
                    type: "step",
                    title: "Pour effacer un élément",
                    content: "Dans la liste des hôtes, sélectionner l'élément que vous souhaitez supprimer et cliquer sur Supprimer au dessus de la liste."
                }
            ]
        },
        ACCESS_CONTROL: {
            TITLE: "Contrôle d'accès",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Le contrôle d'accès est utilisé pour permettre ou interdire aux appareils spécifiés d'accéder à votre réseau. Quand un appareil est bloqué, il peut obtenir une adresse IP depuis le routeur, mais il ne peut communiquer avec les autres appareils ni se connecter à internet."
                }, {
                    type: "paragraph",
                    content: "Pour utiliser le contrôle d'accès, activer cette fonction et spécifier une liste noire ou blanche. Si le contrôle d'accès est désactivé (Off) tous les appareil ainsi que ceux de la liste noire, sont autorisés à se connecter au réseau."
                }
            ]
        },
        ACCESS_MODE: {
            TITLE: "Mode d'accès",
            CONTENT: [
                {
                    type: "name",
                    title: "Liste noire",
                    content: "Seuls les appareils en liste noire n'auront pas accès à votre réseau."
                }, {
                    type: "name",
                    title: "liste blanche",
                    content: "Seuls les appareils en liste blanche auront accès à votre réseau."
                }
            ]
        },
        ACCESS_DEVICE: {
            TITLE: "Appareils en ligne",
            CONTENT: [
                {
                    type: "name",
                    title: "Nom d'appareil",
                    content: "Indique le nom de l'appareil connecté."
                }, {
                    type: "name",
                    title: "Adresse IP",
                    content: "Indique l'adresse IP de l'appareil connecté."
                }, {
                    type: "name",
                    title: "Adresse MAC",
                    content: "Indique l'adresse MAC de l'appareil connecté."
                }, {
                    type: "name",
                    title: "Type de connexion",
                    content: "Affiche le type de connexion de l'appareil connecté."
                }, {
                    type: "step",
                    title: "Pour bloquer un appareil",
                    content: "Dans la liste des appareils connectés, dans la colonne Modifier cliquer sur l'icône Bloquer de l'appareil que vous souhaitez bloquer."
                }, {
                    type: "step",
                    title: "pour bloquer plusieurs appareils",
                    content: "Dans la liste des appareils connectés, sélectionner tous les appareils que vous souhaitez bloquer et cliquer sur Bloquer au dessus de la liste. L'appareil sera automatiquement ajouté à l a liste blanche ou noire."
                }
            ]
        },
        ACCESS_LIST: {
            TITLE: "Appareils en liste noire/blanche",
            CONTENT: [
                {
                    type: "step",
                    title: "Pour ajouter un appareil à la liste noire/blanche",
                    content: ["1. Cliquer sur l'icône Ajouter.", "2. Saisir le nom d'appareil.", "3. Saisir l'adresse MAC de l'appareil.", "4. Cliquer sur OK."]
                }, {
                    type: "step",
                    title: "Pour modifier ou supprimer un appareil de la liste noire/blanche",
                    content: "Dans la liste noire/blanche, cliquer sur l'icône Modifier ou Supprimer correspondant à l'élément que vous souhaitez modifier ou supprimer."
                }, {
                    type: "step",
                    title: "Pour supprimer plusieurs appareils de la liste noire/blanche",
                    content: "Dans la liste noire/blanche, sélectionner tous les éléments que vous souhaitez supprimer et cliquer sur Supprimer au dessus de la liste."
                }
            ]
        },
        IPMAC_BIND_SETTING: {
            TITLE: "Paramètres",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "L'association ARP (Address Resolution Protocol) est utile pour contrôler l'accès d'un ordinateur spécifique en associant son adresse IP et son adresse MAC. L'association ARP empêche aussi d'autres appareils d'utiliser une adresse IP spécifique."
                }
            ]
        },
        IPMAC_BIND_ARP: {
            TITLE: "Liste ARP",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Indique les adresses IP et MAC des appareils connectés."
                }, {
                    type: "name",
                    title: "Numéro d'entrée ARP",
                    content: "Indique le nombre d'appareils actuellement connectés au routeur."
                }, {
                    type: "name",
                    title: "Adresse MAC",
                    content: "Indique l'adresse MAC de l'appareil connecté."
                }, {
                    type: "name",
                    title: "Adresse IP",
                    content: "Indique l'adresse IP attribuée à l'appareil connecté."
                }, {
                    type: "name",
                    title: "Lié",
                    content: "Indique si les adresse IP & MAC sont liées ou non."
                }, {
                    type: "name",
                    title: "Modifier",
                    content: "Affiche les options pour Associer ou Supprimer l'élément correspondant de la liste."
                }, {
                    type: "note",
                    title: "Remarque",
                    content: "Vous ne pouvez associer une adresse IP a plusieurs adresses MAC."
                }
            ]
        },
        IPMAC_BIND_LIST: {
            TITLE: "Liste d'association",
            CONTENT: [
                {
                    type: "step",
                    title: "Pour définir une association ARP pour un appareil",
                    content: [
                        "1. Cliquer sur Ajouter.",
                        "2. Saisir l'adresse MAC de l'appareil.",
                        "3. Saisir une adresse IP que vous souhaitez associer à l'adresse MAC ci-contre.",
                        "4. Saisir une description pour cet appareil. (Optionnel)",
                        "5. Sélectionner Activer.",
                        "6. Cliquer sur OK."
                    ]
                }, {
                    type: "step",
                    title: "Pour modifier ou effacer un élément",
                    content: "Dans la liste des associations, cliquer sur l'icône Modifier ou Supprimer correspondant à l'élément que vous souhaitez modifier ou supprimer."
                }, {
                    type: "step",
                    title: "Pour effacer plusieurs éléments",
                    content: "Dans la liste des associations, sélectionner tous les éléments que vous souhaitez supprimer et cliquer sur Supprimer au dessus de la liste."
                }
            ]
        },
        IPV6: {
            TITLE: "Internet",
            CONTENT: [
                {
                    type: "name",
                    title: "IPv6",
                    content: "Sélectionner pour Activer (On) ou Désactiver (Off) la fonctionnalité IPv6 du routeur."
                }, {
                    type: "title",
                    title: "Type de connexion internet : IP Statique"
                }, {
                    type: "name",
                    title: "IP Statique",
                    content: "Sélectionner ce type si votre FAI utilise une assignation d'adresses IPv6 fixes."
                }, {
                    type: "name",
                    title: "Adresse IPv6/Passerelle par défaut/DNS primaire/DNS secondaire",
                    content: "Saisir ces paramètres tels que fournis par le FAI."
                }, {
                    type: "name",
                    title: "Taille de la MTU",
                    content: "La taille de MTU (Maximum Transmission Unit) typique pour la plupart des réseaux Ethernet est de 1500 Octets. Il n'EST pas recommandé de modifier la taille par défaut de la MTU sauf si votre FAI le requiert."
                }, {
                    type: "title",
                    title: "Type de connexion internet : IP Dynamique"
                }, {
                    type: "name",
                    title: "IP dynamique",
                    content: "Sélectionner ce type si votre FAI utilise une attribution dynamique d'adresses IPv6."
                }, {
                    type: "name",
                    title: "Adresse IPv6/DNS primaire/DNS secondaire",
                    content: "Ces paramètres sont automatiquement assignés par le serveur DHCPv6 de votre FAI."
                }, {
                    type: "name",
                    title: "Renouveler",
                    content: "Cliquer sur ce bouton pour obtenir de nouveaux paramètres IPv6 de la part du serveur DHCPv6 de votre FAI."
                }, {
                    type: "name",
                    title: "Relâcher",
                    content: "Cliquer sur ce bouton pour libérer toutes les adresses IPv6 assignées par le serveur DHCPv6 de votre FAI."
                }, {
                    type: "name",
                    title: "Obtenir une adresse IPv6",
                    content: "Sélectionner \"Obtenir une adresse IPv6 non temporaire\" ou \"Obtenir un préfixe de délégation IPv6\", en fonction de ce que requiert votre FAI."
                }, {
                    type: "name",
                    title: "Adresse DNS",
                    content: "Sélectionner \"Obtenir dynamiquement du FAI\" ou \"Utiliser les adresses DNS suivantes\". Si \"Utiliser les adresses DNS suivantes\" est sélectionner, saisir les adresses DNS fournies par votre FAI."
                }, {
                    type: "name",
                    title: "DNS primaire/secondaire",
                    content: "Saisir ces paramètres manuellement ou obtenus dynamiquement depuis le FAI."
                }, {
                    type: "title",
                    title: "Type de connexion internet : PPPoE"
                }, {
                    type: "name",
                    title: "PPPoE",
                    content: "Sélectionner ce type si votre FAI utilise PPPov6 et vous fourni le nom d'utilisateur et le mot de passe."
                }, {
                    type: "name",
                    title: "Nom d'utilisateur / Mot de passe",
                    content: "Saisir ces paramètres tels que fournis par votre FAI."
                }, {
                    type: "name",
                    title: "Adresse IPv6",
                    content: "Sera automatiquement assignée par le serveur DHCPv6 du FAI, après saisie du nom d'utilisateur, du mot de passe et avoir cliqué sur Se connecter."
                }, {
                    type: "name",
                    title: "Adresse DNS",
                    content: "Sélectionner \"Obtenir dynamiquement du FAI\" ou \"Utiliser les adresses DNS suivantes\". Si \"Utiliser les adresses DNS suivantes\" est sélectionner, saisir les adresses DNS fournies par votre FAI."
                }, {
                    type: "name",
                    title: "Obtenir une adresse IPv6",
                    content: "Sélectionner \"Non temporaire\" ou \"Délégation de préfixe\" ou \"Spécifié par le FAI\" conformément à ce que requiert le FAI. Si vous sélectionnez \"Spécifié par le FAI\", vous devez saisir manuellement l'adresse IPv6 telle que fournie par votre FAI. Si vous sélectionnez ''Non-temporaire'' ou ''Délégation de préfixe'', l'adresse IPv6 sera automatiquement assignée par le serveur DHCPv6 du FAI.",
                    children: [
                        {
                            type: "name",
                            title: "Non temporaire",
                            content: "Obtenir une adresse IPv6 non temporaire du serveur DHCPv6 du FAI."
                        }, {
                            type: "name",
                            title: "Délégation de préfixe",
                            content: "Obtenir une délégation de préfixe IPv6 depuis le serveur DHCPv6 du FAI, et le client côté LAN crée une adresse IPv6 avec la délégation."
                        }, {
                            type: "name",
                            title: "Défini par le FAI",
                            content: "Utiliser une adresse IPv6 statique fournie par le FAI."
                        }
                    ]
                }, {
                    type: "name",
                    title: "Se connecter",
                    content: "Cliquer sur ce bouton pour vous connecter à internet."
                }, {
                    type: "name",
                    title: "Déconnecter",
                    content: "Cliquer sur ce bouton pour vous déconnecter d'internet."
                }, {
                    type: "title",
                    title: "Type de connexion internet : 6To4"
                }, {
                    type: "name",
                    title: "Tunnel 6To4",
                    content: "Sélectionner ce type si votre FAI utilise un déploiement 6to4 pour vous attribuer une adresse."
                }, {
                    type: "name",
                    title: "Adresse IPv4/Masque de sous-réseau IPv4/Passerelle par défaut IPv4/Adresse de tunnel",
                    content: "Ces paramètres sont automatiquement générés par les paramètres IPv4 du port WAN après avoir cliqué sur Se Connecter."
                }, {
                    type: "name",
                    title: "Utiliser le serveur DNS suivant",
                    content: "Cocher la case pour activer cette option. Puis saisir le DNS primaire/DNS secondaire fournis par votre FAI."
                }, {
                    type: "name",
                    title: "Se connecter",
                    content: "Cliquer sur ce bouton pour vous connecter à internet."
                }, {
                    type: "name",
                    title: "Déconnecter",
                    content: "Cliquer sur ce bouton pour vous déconnecter d'internet."
                }, {
                    type: "title",
                    title: "Type de connexion internet : 6RD"
                }, {
                    type: "name",
                    title: "6rd",
                    content: "Sélectionner ce type si votre FAI utilise un déploiement 6RD et vous fourni une adresse IPv4 et un préfixe d'adresse IPv6."
                }, {
                    type: "name",
                    title: "Type de configuration",
                    content: "Sélectionner Auto ou Manuel pour configurer les paramètres de canal 6RD en fonction de votre FAI. Si les paramètres par défaut coïncident avec ceux fournis par votre FAI, vous pouvez sélectionner Auto sinon sélectionner Manuel et saisir les paramètres fournis par votre FAI."
                }, {
                    type: "name",
                    title: "Longueur de masque IPv4/Préfixe 6RD/Longueur de préfixe 6RD/Adresse IPv4 Border Reply",
                    content: "Vérifier que les paramètres prédéfinis coïncident avec ceux fournis par votre FAI, et conservez les ou modifiez les pour qu'ils correspondent à ceux de votre FAI."
                }, {
                    type: "title",
                    title: "Type de connexion internet : DS-Lite"
                }, {
                    type: "name",
                    title: "DS-Lite",
                    content: "Sélectionner ce type si votre FAI utilise un déploiement DS-Lite, et vous fourni un nom de domaine AFTR ou une adresse IPv6, pour paramétrer un tunnel IPv4 via IPv6 dans le réseau IPv6 pour des communications IPv4 ou IPv6 dans leurs réseaux respectifs."
                }, {
                    type: "name",
                    title: "Nom AFTR",
                    content: "AFTR est l'abréviation d' Address Family Transition Router. Dans ce champ, saisir le nom de domaine AFTR ou l'adresse IPv6 fournie par votre FAI."
                }, {
                    type: "name",
                    title: "Connexion secondaire",
                    content: "Choisir le type de connexion secondaire tel qu'indiqué par votre FAI.",
                    children: [
                        {
                            type: "name",
                            title: "IP dynamique",
                            content: "Sélectionner si votre FAI fourni une connexion secondaire de type IP dynamique ; les paramètres IPv6 (Adresse, DNS primaire et secondaire) seront automatiquement attribués par le serveur DHCPv6 du FAI."
                        }, {
                            type: "name",
                            title: "IP Statique",
                            content: "Sélectionner ce type si votre FAI utilise une assignation d'adresses IPv6 fixes."
                        }, {
                            type: "name",
                            title: "PPPoE",
                            content: "Sélectionner si votre FAI vous fourni une connexion PPPoE pour la connexion secondaire ; saisir le nom d'utilisateur et le mot de passe indiqués par votre FAI. L'adresse IPv6 sera automatiquement assignée après avoir cliqué sur Se connecter."
                        }
                    ]
                }, {
                    type: "title",
                    title: "Type de connexion internet : Traversée (Bridge)"
                }, {
                    type: "paragraph",
                    content: "Sélectionner ce type si votre FAI utilise un déploiement réseau de type Pont (PassThrough). Pour ce type, aucun paramètres n'est fourni et aucune configuration n'est requise."
                }
            ]
        },
        IPV6_LAN: {
            TITLE: "LAN",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Sauf pour le pont (traversée), les 6 autres types de connexions à internet requièrent la configuration des paramètres LAN IPv4 en même temps."
                }, {
                    type: "name",
                    title: "Type assigné",
                    content: "Sélectionner celui approprié et requis par votre FAI.",
                    children: [
                        {
                            type: "name",
                            title: "DHCPv6",
                            content: "Pour assigner automatiquement des adresses IP aux clients du LAN.",
                            children: [
                                {
                                    type: "name",
                                    title: "Préfixe d'adresse",
                                    content: "Saisir le préfixe d'adresse tel que fourni par votre FAI."
                                }, {
                                    type: "name",
                                    title: "Délai de conservation",
                                    content: "Correspond à la durée restante pendant laquelle l'adresse IP attribuée est réservée. Conserver la valeur par défaut : 86400 ou modifiez la si votre FAI le requiert."
                                }, {
                                    type: "name",
                                    title: "Adresse",
                                    content: "C'est l'adresse IP automatiquement assignée par le serveur DHCPv6 du FAI."
                                }
                            ]
                        }, {
                            type: "name",
                            connector: " ",
                            title: "SLAAC+Stateless DHCP",
                            children: [
                                {
                                    type: "name",
                                    title: "Préfixe d'adresse",
                                    content: "Saisir le préfixe d'adresse tel que fourni par votre FAI."
                                }, {
                                    type: "name",
                                    title: "Adresse",
                                    content: "C'est l'adresse IP automatiquement assignée par le serveur DHCPv6 du FAI."
                                }
                            ]
                        }, {
                            type: "name",
                            connector: " ",
                            title: "SLAAC+RDNSS",
                            children: [
                                {
                                    type: "name",
                                    title: "Préfixe d'adresse",
                                    content: "Saisir le préfixe d'adresse tel que fourni par votre FAI."
                                }, {
                                    type: "name",
                                    title: "Adresse",
                                    content: "C'est l'adresse IP automatiquement assignée par le serveur DHCPv6 du FAI."
                                }
                            ]
                        }
                    ]
                }
            ]
        },
        IPV6_MAC_CLONE: {
            TITLE: "Clonage d'adresse MAC",
            CONTENT: [
                {
                    type: "name",
                    title: "Utiliser l'adresse MAC par défaut",
                    content: "NE pas changer l'adresse MAC par défaut du routeur, au cas ou le FAI n'associe pas l'adresse IP assignée à l'adresse MAC."
                }, {
                    type: "name",
                    title: "Utiliser l'adresse MAC de l'ordinateur",
                    content: "Sélectionner pour copier l'adresse MAC de l'ordinateur connecté au routeur, au cas ou le FAI associe l'adresse IP associée à l'adresse MAC de cet ordinateur."
                }, {
                    type: "name",
                    title: "Utiliser une adresse MAC personnalisée",
                    content: "Saisir l'adresse MAC manuellement, au cas ou le FAI associe l'adresse IP assignée à une adresse MAC spécifique."
                }
            ]
        },
        TIME_SETTING: {
            TITLE: "Paramètres horaires",
            CONTENT: [
                {
                    type: "step",
                    title: "Pour synchroniser automatiquement l'heure",
                    content: ["1. Sélectionner votre <b>Fuseau horaire</b> depuis la liste déroulante.", "2. Dans le champ <b>Serveur NTP I</b>, saisir l'adresse IP du serveur choisi. (Optionnel)", "3. Dans le champ <b>Serveur NTP II</b>, saisir l'adresse IP du serveur choisi. (Optionnel)", "4. Cliquer sur <b>Obtenir l'heure GMT</b>."]
                }, {
                    type: "step",
                    title: "Pour définir manuellement la date et l'heure",
                    content: ["1. Dans le champ <b>Paramètres horaires,</b> sélectionner votre <b>Fuseau horaire.</b>", "2. Saisir la <b>date</b> courante.", "3. Définissez <b>l'heure</b> actuelle (au format HH:MM:SS, exemple 16:00:00 pour 4:00PM)", "4. Cliquer sur <b>Sauvegarder</b>."]
                }
            ]
        },
        TIME_SETTING_DAYLIGHT: {
            TITLE: "Heure d'été",
            CONTENT: [
                {
                    type: "step",
                    title: "Pour définir les paramètres d'heure d'été.",
                    content: ["1. Sélectionner <b>Activer l'heure d'été</b>.", "2. Sélectionner la date et l'heure de <b>Début</b> de passage à l'heure d'été officielle de votre emplacement.", "3. Sélectionner la date et l'heure de <b>Fin</b> de l'heure d'été officielle qui s'applique à l'endroit ou est installé le routeur.", "4. Cliquer sur <b>Sauvegarder</b>."]
                }
            ]
        },
        DIGNOSTIC: {
            TITLE: "Diagnostics",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Le routeur dispose d'outils de Ping et de Traceroute pour vous aider à diagnostiquer les problèmes de connectivité réseau. Le Ping envoi des paquets à une adresse IP ou à nom de domaine et enregistre les résultats, tels que le nombre de paquets émis/reçus et le temps de réponse. La fonction Traceroute envoi des paquets à une adresse IP ou à nom de domaine cible et affiche le nombre de sauts et le temps mis à atteindre la destination."
                }, {
                    type: "paragraph",
                    content: "Vous pouvez faire un Ping ou un Traceroute d'un appareil local par son adresse IP ou son nom de domaine."
                }, {
                    type: "step",
                    title: "Pour un diagnostic par Ping",
                    content: ["1. Saisir l'adresse IP ou le nom de domaine cible.", "2. (Optionnel) (Optionnel)", "3. Cliquer sur Démarrer."]
                }, {
                    type: "step",
                    title: "Pour un diagnostic par Traceroute",
                    content: ["1. Saisir l'adresse IP ou le nom de domaine cible.", "2. Cliquer sur l'icône Flèche pour ouvrir le menu Avancé et spécifier le nombre de sauts (à atteindre) dans le champ Traceroute Max TTL. (Optionnel) (Optionnel)", "3. Cliquer sur Démarrer."]
                }
            ]
        },
        FIRMWARE: {
            TITLE: "Mise à jour logicielle",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Avant de mettre à jour le firmware de votre extenseur CPL, vous devrez télécharger le plus récent depuis <a class=\"link\" href=\"http://www.tp-link.com/fr/support/\" target=\"_blank\">la page Support</a> du site TP-link."
                }, {
                    type: "step",
                    title: "Important : pour éviter les problèmes de mise à jour, merci de noter ce qui suit :",
                    content: ["Assurez vous que le firmware le plus récent correspond à la version matérielle indiquée en bas de la page de mise à jour.", "Assurez vous d'avoir une connexion stable entre l'extenseur CPL et votre ordinateur. Il n'EST pas recommandé de mettre le firmware par un accès Wi-Fi.", "Sauvegarder la configuration de votre extenseur CPL.", "NE pas mettre l'extenseur CPL hors tension pendant la mise à jour du firmware."]
                }, {
                    type: "step",
                    title: "Pour mettre à jour le firmware de l'extenseur CPL",
                    content: ["1. Cliquer sur <b>Naviguer</b>.", "2. Localiser et sélectionner le firmware téléchargé.", "3. Cliquer sur <b>Mettre à jour</b>."]
                }, {
                    type: "paragraph",
                    content: "La mise à jour prend quelques minutes. Merci de ne PAS mettre l'extenseur CPL hors tension pendant la mise à jour."
                }
            ]
        },
        FIRMWARE_UPGRADE_ONLINE: {
            TITLE: "Pour une mise à jour via internet.",
            CONTENT: [
                {
                    type: "paragraph",
                    content: ["Cliquez sur <b>Mettre à jour</b> et ensuite cliquez sur <b>Oui</b>, puis le extenseur téléchargera automatiquement la dernière version du firmware et le fichier de mise à niveau. Vous pouvez également cliquer sur <b>Vérifier la mise à niveau</b> pour vérifier si vous possédez bien la dernière version."]
                }
            ]
        },
        FIRMWARE_UPGRADE: {
            TITLE: "Pour une mise à jour manuelle.",
            CONTENT: [
                {
                    type: "step",
                    content: ["1. Cliquer sur Support en bas de cette page et télécharger le firmware le plus récent disponible. Assurez-vous que le fichier de firmware que vous allez télécharger correspond bien à la version matérielle du extenseur mentionnée sur cette page.", "2. Cliquer sur Naviguer et sélectionner le firmware téléchargé.", "3. Cliquer sur Mettre à jour."]
                }, {
                    type: "paragraph",
                    content: ["La mise à jour logicielle prend quelques instants pour s'achever. Le extenseur redémarrera automatiquement à l'issue de la mise à jour."]
                }
            ]
        },
        BACKUP: {
            TITLE: "Sauvegarde",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Il est fortement conseillé de sauvegarder votre configuration actuelle, au cas ou une récupération est requise pour restaurer le système à un état antérieur ou depuis la configuration par défaut."
                }, {
                    type: "paragraph",
                    content: "Cliquer sur <b>Sauvegarder</b> pour faire une copie de la configuration actuelle sur votre ordinateur. Assurez vous d'enregistrer le fichier de sauvegarde dans un emplacement sécurisé afin de restaurer l'extenseur si nécessaire."
                }
            ]
        },
        RESTORE: {
            TITLE: "Restaurer",
            CONTENT: [
                {
                    type: "step",
                    title: "Pour restaurer depuis une sauvegarde",
                    content: ["1. Cliquer sur <b>Naviguer</b>.", "2. Localiser et sélectionner le fichier de sauvegarde.", "3. Cliquer sur <b>Restaurer</b>."]
                }
            ]
        },
        FACTORY: {
            TITLE: "Restaurer les paramètres par défaut",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Cliquer sur <b>Paramètres d'usine</b> pour réinitialiser l'extenseur à ses paramètres par défaut."
                }, {
                    type: "note",
                    title: "Remarque",
                    content: ["1. Cette restauration supprimera toutes modifications que vous aurez apporté à la configuration initiale de l'extenseur CPL. Pour vous reconnecter à l'interface WEB d'administration de l'extenseur, utilisez la valeur par défaut : <b>admin</b> pour le nom d'utilisateur et le mot de passe.", "2. Merci de ne PAS éteindre l'extenseur CPL pendant la phase de sauvegarde ou de restauration de la configuration de l'extenseur."]
                }
            ]
        },
        ADMIN_ACCOUNT: {
            TITLE: "Administration de compte",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Cette page vous permet de modifier le nom d'utilisateur et le mot de passe de connexion."
                }, {
                    type: "name",
                    title: "Ancien nom d'utilisateur",
                    content: "Saisir le nom d'utilisateur actuel."
                }, {
                    type: "name",
                    title: "Ancien mot de passe",
                    content: "Saisir le mot de passe actuel."
                }, {
                    type: "name",
                    title: "Nouveau nom d'utilisateur",
                    content: "Saisir le nouveau nom d'utilisateur."
                }, {
                    type: "name",
                    title: "Nouveau mot de passe",
                    content: "Saisir le nouveau mot de passe."
                }, {
                    type: "name",
                    title: "Confirmer le nouveau mot de passe",
                    content: "Saisir une seconde fois le nouveau mot de passe."
                }, {
                    type: "note",
                    title: "Remarque",
                    content: "Si vous modifiez le nom d'utilisateur et le mot de passe utilisés pour vous connecter à l'extenseur CPL, assurez vous de noter les nouveaux paramètres en lieu sûr. Un mot de passe fort devrait comporter au moins 8 caractères, combinant majuscules, minuscules chiffres et ponctuation."
                }, {
                    type: "paragraph",
                    content: "Cliquer sur <b>Sauvegarder</b> pour enregistrer tous vos paramètres."
                }
            ]
        },
        ADMIN_RECOVERY: {
            TITLE: "Récupération de mot de passe",
            CONTENT: [
                {
                    type: "name",
                    title: "Activer la récupération du mot de passe",
                    content: "Il est fortement conseillé d'activer la fonction de récupération du mot de passe, qui vous enverra par courriel, le nom d'utilisateur et le mot de passe oubliés."
                }, {
                    type: "name",
                    title: "De ",
                    content: "Saisir l'adresse courriel valide utilisée pour les messages sortants."
                }, {
                    type: "name",
                    title: "à",
                    content: "Saisir l'adresse courriel valide utilisée pour les messages entrants."
                }, {
                    type: "name",
                    title: "Serveur SMTP",
                    content: "Saisir l'adresse du serveur SMTP que le routeur utilisera pour envoyer les informations du compte par courriel."
                }, {
                    type: "name",
                    title: "Activer l'authentification",
                    content: "Sélectionner Activer l'authentification si le serveur de messagerie requiert une authentification avant l'envoi d'un courriel, complétez les champs Nom d'utilisateur et Mot de passe. Ces champs différencient minuscules et majuscules"
                }
            ]
        },
        ADMIN_LOCAL: {
            TITLE: "Administration locale",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Cette section vous permet de limiter le nombre d'appareils clients réseau à accéder au routeur en fonction de leur adresse MAC."
                }, {
                    type: "name",
                    title: "Accès pour tous les appareils connectés au LAN",
                    content: "Basculer sur On pour activer l'administration locale par tout client connecté au LAN ou sur Off pour n'autoriser qu'un appareil spécifique."
                }, {
                    type: "name",
                    title: "Adresse MAC",
                    content: "Affiche l'adresse MAC de l'appareil dont l'accès est limité."
                }, {
                    type: "name",
                    title: "Description",
                    content: "Affiche la description de l'appareil dont l'accès est limité."
                }, {
                    type: "name",
                    title: "Etat",
                    content: "Affiche l'état actuel (actif ou inactif) de la limitation d'accès de l'appareil."
                }, {
                    type: "name",
                    title: "Modifier",
                    content: "Affiche les options pour Modifier ou Supprimer l'appareil correspondant de la liste."
                }, {
                    type: "step",
                    title: "Pour ajouter un appareil client à la liste",
                    content: ["1. Cliquer sur Ajouter.", "2. Cliquer sur Voir les appareils pour choisir un appareil ou saisir son adresse MAC dans le champ dédié.", "3. Saisir une description pour l'appareil. (Optionnel)", "4. Sélectionner Activer.", "5. Cliquer sur OK."]
                }, {
                    type: "step",
                    title: "Pour modifier ou supprimer un appareil de la liste",
                    content: "Cliquer sur l'icône Modifier ou Supprimer correspondant à l'appareil que vous souhaitez modifier ou supprimer."
                }, {
                    type: "step",
                    title: "Pour effacer plusieurs appareils",
                    content: "Sélectionner tous les appareils que vous souhaitez supprimer, cliquer sur Supprimer."
                }
            ]
        },
        ADMIN_REMOTE: {
            TITLE: "Administration distante",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "La fonction d'administration distante vous permet de configurer le routeur depuis internet."
                }, {
                    type: "name",
                    title: "Désactiver l'administration distante",
                    content: "Sélectionner cette option pour désactiver l'administration distante."
                }, {
                    type: "name",
                    title: "Permettre l'administration distante à tous les appareils",
                    content: "Sélectionner cette option pour activer l'administration distante pour n'importe quelle adresse IP. Si sélectionné, saisir le port d'administration distante dans le champ dédié."
                }, {
                    type: "name",
                    title: "Permettre l'administration distante aux appareils sélectionnés",
                    content: "Sélectionner cette option pour activer l'administration distante pour une adresse IP spécifique. Si sélectionné, saisir l'adresse IP et le port d'administration distante dans les champs dédiés."
                }, {
                    type: "name",
                    title: "Port d'administration Web",
                    content: "Saisir le numéro de port (1024 - 65535) qui sera utilisé pour accéder de façon plus sécurisée à l'adresse Web d'administration du routeur. Normalement, les navigateurs utilisent le port de service standard 80 pour HTTP. Le port de service commun et par défaut est 8080, port HTTP alternatif."
                }, {
                    type: "name",
                    title: "Adresse IP d'administration distante",
                    content: "Saisir une adresse ou un plage d'adresses IP valide autorisée à accéder au routeur. Si vous saisissez 255.255.255.255, tout le monde est autorisé."
                }
            ]
        },
        SYSTEM_LOG: {
            TITLE: "Journal d'évènements",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "La page des messages système affiche la liste des événements les plus récents concernant l'extenseur. Vous pouvez définir quel type d'enregistrement et/ou quel niveau d'enregistrement vous souhaitez afficher."
                }, {
                    type: "name",
                    title: "Type",
                    content: "Choisir le type d'évènements à afficher."
                }, {
                    type: "name",
                    title: "Niveau",
                    content: "Choisir le niveau d'information à afficher."
                }, {
                    type: "name",
                    title: "Rafraîchir",
                    content: "Cliquer sur cette icône pour mettre à jour le journal d'évènement."
                }, {
                    type: "name",
                    title: "Tout supprimer",
                    content: "Cliquer sur cette icône pour effacer le journal d'évènement."
                }, {
                    type: "name",
                    title: "Sauvegarder le journal",
                    content: "Cliquer sur ce bouton pour télécharger le fichier des messages système sur votre ordinateur."
                }
            ]
        },
        TRAFFIC_STATISTIC: {
            TITLE: "Statistiques de trafic",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "La page de statistiques de trafic affiche le trafic réseau relatif aux paquets émis et reçus via le LAN, le WAN et le Wi-Fi."
                }, {
                    type: "note",
                    title: "Remarque",
                    content: "Si le NAT Boost est activé, les statistiques de trafic doivent être désactivées."
                }, {
                    type: "name",
                    title: "Statistiques de trafic",
                    content: "Par défaut les statistiques de trafic sont inactives. Pour afficher les informations statistiques, cliquer sur On."
                }
            ]
        },
        TRAFFIC_STATISTIC_LIST: {
            TITLE: "Liste des statistiques de trafic",
            CONTENT: [
                {
                    type: "name",
                    title: "Adresse IP/MAC",
                    content: "Affiche l'adresse IP et l'adresse MAC de l'appareil client associé."
                }, {
                    type: "name",
                    title: "Paquets totaux",
                    content: "Indique le nombre de paquets reçus et émis par le client depuis la mise sous tension ou la réinitialisation du compteur."
                }, {
                    type: "name",
                    title: "Octets totaux",
                    content: "Indique le nombre d'octets reçus et émis par le client depuis la mise sous tension ou la réinitialisation du compteur."
                }, {
                    type: "name",
                    title: "Paquets actuels",
                    content: "Affiche le nombre de paquets transmis et reçus pendant un intervalle de temps déterminé."
                }, {
                    type: "name",
                    title: "Octets actuels",
                    content: "Affiche le nombre d'octets transmis et reçus pendant un intervalle de temps déterminé."
                }, {
                    type: "name",
                    title: "ICMP Tx Actuel",
                    content: "Affiche le débit actuel et maximal de paquets ICMP transmis au travers du port WAN par seconde."
                }, {
                    type: "name",
                    title: "UDP Tx Actuel",
                    content: "Affiche le débit actuel et maximal de paquets UDP transmis au travers du port WAN par seconde."
                }, {
                    type: "name",
                    title: "SYN Tx Actuel",
                    content: "Affiche le débit actuel et maximal de paquets TCP SYN transmis au travers du port WAN par seconde."
                }, {
                    type: "name",
                    title: "Modifier",
                    content: "Affiche les options pour réinitialiser (mettre à zéro) ou Supprimer les statistiques correspondantes de la liste."
                }, {
                    type: "name",
                    title: "Rafraîchir",
                    content: "Cliquer pour mettre à jour les informations statistiques sur cette page."
                }, {
                    type: "name",
                    title: "Tout réinitialiser",
                    content: "Cliquer pour réinitialiser à zéro les valeurs de statistiques."
                }, {
                    type: "name",
                    title: "Tout supprimer",
                    content: "Cliquer pour effacer toutes les informations statistiques de la liste."
                }
            ]
        },
        SYSTEM_PARA_WIRELESS: {
            TITLE: "Wi-Fi 2.4 GHz / 5 GHz",
            CONTENT: [
                {
                    type: "name",
                    title: "Intervalle entre balises ",
                    content: "Saisir une valeur comprise entre 40 et 1000 ms déterminant le délai entre les paquets balise qui sont diffusés par le routeur pour synchroniser le réseau Wi-Fi. La valeur par défaut est 100 millisecondes."
                }, {
                    type: "name",
                    title: "Seuil RTS",
                    content: "Saisir une valeur comprise entre 1 et 2346 déterminant la taille des paquets de données transmis via le routeur. Par défaut, la taille du seuil RTS (Request To Send) est 2346. Si la taille de paquet est supérieure au seuil paramétré, le routeur envoie des trames \"Request To Send\" à une station particulière et négocie l'envoi d'une trame de données sinon le paquet est immédiatement transmis."
                }, {
                    type: "name",
                    title: "Intervalle DTIM",
                    content: "Cette valeur détermine l'intervalle DTIM (Delivery Traffic Indication Message). Saisir une valeur comprise entre 1 et 15 millisecondes. La valeur par défaut est 1, indiquant que l'intervalle DTIM est identique à l'intervalle entre balises."
                }, {
                    type: "name",
                    title: "Fréquence de mise à jour des clés",
                    content: "Saisir le nombre de secondes (>30) correspondant à l'intervalle de renouvellement de la clé de chiffrement. La valeur par défaut : 0 indique pas de renouvellement de la clé."
                }, {
                    type: "name",
                    title: "Fonction WMM",
                    content: "La fonction WMM garantie la transmission préférentielle des paquets à priorité haute. C'est activé par défaut et fortement recommandé."
                }, {
                    type: "name",
                    title: "Fonction d'intervalle de garde court",
                    content: "Cette fonction est recommandée et activée par défaut pour augmenter la capacité de données en réduisant la durée de l'intervalle de garde."
                }, {
                    type: "name",
                    title: "Fonctionnalité d'isolement",
                    content: "Par défaut, cette fonction est désactivée. Si vous souhaitez confiner et restreindre les communications entre tous les appareils Wi-Fi connectés à votre réseau tout en leur laissant l'accès à internet, cocher la case Activer l'isolation."
                }, {
                    type: "name",
                    title: "Pontage WDS",
                    content: "Activer le pontage WDS (Wireless Distribution System) pour permettre au routeur de se connecter à un autre point d'accès (AP) via un réseau Wi-Fi local (WLAN). Si cette fonction est activée, configurez les éléments suivants :",
                    children: [
                        {
                            type: "name",
                            title: "SSID",
                            content: "Saisir le SSID du point d'accès auquel le routeur se connectera ou utiliser la fonction détection pour lister les réseaux Wi-Fi joignables sur ce canal."
                        }, {
                            type: "name",
                            title: "Détecter",
                            content: "Cliquer sur ce bouton pour détecter et afficher les SSID, BSSID, Force de signal, Canal et informations de sécurité de tous les réseaux Wi-Fi joignables. Une fois que vous avez sélectionné un réseau, les champs SSID, l'adresse MAC, et la sécurité sont complétés."
                        }, {
                            type: "name",
                            title: "Adresse MAC (à ponter)",
                            content: "Saisir l'adresse MAC Wi-Fi (BSSID) du point d'accès auquel se connectera le routeur, au format hexadécimal (0-9, A-F, a-f) en séparant chaque octet par des tirets. Si vous choisissez le point d'accès à l'aide de la fonction Détection, l'adresse MAC est automatiquement insérée dans le champ dédié."
                        }, {
                            type: "name",
                            title: "Sécurité",
                            content: "Sélectionner le type de chiffrement adéquat pour le point d'accès sélectionné : Aucun, WPA-PSK/WPA2-PSK ou WEP. Si vous sélectionnez \"Spécifié par le FAI\", vous devez saisir manuellement l'adresse IPv6 telle que fournie par votre FAI.",
                            children: [
                                {
                                    type: "name",
                                    title: "Mot de passe",
                                    content: "Cette option est disponible quand le type de chiffrement est WPA-PSK/WPA2-PSK ou WEP. Saisir le mot de passe Wi-Fi du point d'accès sélectionné."
                                }, {
                                    type: "name",
                                    title: "Type Auth.",
                                    content: "Cette option n'est disponible que lorsque le type de chiffrement est WEP (Wireless Equivalent Privacy). Sélectionner le type d'authentification utilisé par le point d'accès sélectionné (Auto, Système ouvert ou Clé partagée)."
                                }, {
                                    type: "name",
                                    title: "Format de clé WEP",
                                    content: "Cette option n'est disponible que lorsque le type de chiffrement est WEP. Sélectionner le format de la clé (ASCII ou hexadécimal) utilisée par le point d'accès."
                                }
                            ]
                        }
                    ]
                }, {
                    type: "paragraph",
                    content: "Cliquer sur Sauvegarder pour enregistrer vos paramètres."
                }
            ]
        },
        SYSTEM_PARA_WPS: {
            TITLE: "WPS",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Cocher la case Activer WPS et cliquer sur Sauvegarder pour activer la fonction Wi-Fi Protected Setup qui vous permet de vous connecter à un appareil supportant cette fonction d'un simple appui de bouton."
                }
            ]
        },
        SYSTEM_PARA_NAT: {
            TITLE: "NAT",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Cocher la case Activer NAT et cliquer sur Sauvegarder pour activer la fonction Network Address Translation."
                }, {
                    type: "name",
                    title: "NAT Boost",
                    content: "Cocher la case Activer NAT Boost et cliquer sur Sauvegarder pour que votre routeur offre le meilleur débit."
                }, {
                    type: "note",
                    title: "Remarque",
                    content: "La fonction NAT Boost est désactivée quand la QoS ou les statistiques de trafic sont actives."
                }
            ]
        },
        SYSTEM_PARA_DOS: {
            TITLE: "Paramètres de niveau de protection DoS",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Le niveau de protection contre les DoS protège le routeur des attaques par saturation TCP-SYN, UDP et ICMP."
                }, {
                    type: "name",
                    title: "Niveau de paquet ICMP-FLOOD",
                    content: "Saisir une valeur comprise entre 5 et 7200 paquets ICMP, déclenchant la protection contre la saturation ICMP quand le nombre de paquets dépasse le seuil fixé."
                }, {
                    type: "name",
                    title: "Niveau de paquets UDP-FLOOD",
                    content: "Saisir une valeur comprise entre 5 et 7200 paquets UDP, déclenchant la protection contre la saturation UDP quand le nombre de paquets dépasse le seuil fixé."
                }, {
                    type: "name",
                    title: "Niveau de paquets TCP-FLOOD",
                    content: "Saisir une valeur comprise entre 5 et 7200 paquets TCP-SYN, déclenchant la protection contre la saturation TCP-SYN quand le nombre de paquets dépasse le seuil fixé."
                }, {
                    type: "paragraph",
                    content: "Cliquer sur Sauvegarder pour enregistrer vos paramètres."
                }
            ]
        },
        SYSTEM_PARA_DUPLEX: {
            TITLE: "Duplex",
            CONTENT: [
                {
                    type: "name",
                    title: "Duplex",
                    content: "Sélectionner le type de duplex depuis la liste déroulante."
                }, {
                    type: "paragraph",
                    content: "Cliquer sur Sauvegarder pour enregistrer vos paramètres."
                }
            ]
        },
        BASIC_NETWORK_INTEREST: {
            TITLE: "Internet",
            CONTENT: [
                {
                    type: "name",
                    title: "Etat de la connexion internet",
                    content: "Indique l'état actuel de la connexion internet du routeur."
                }, {
                    type: "name",
                    title: "Type de connexion",
                    content: "indique le type de connexion internet."
                }, {
                    type: "name",
                    title: "Adresse IP",
                    content: "Indique l'adresse IP publique (internet) assignée au routeur."
                }, {
                    type: "name",
                    title: "Connexion secondaire/Adresse IP",
                    content: "Indique le type de connexion secondaire et son adresse IP."
                }
            ]
        },
        BASIC_NETWORK_ROUTER: {
            TITLE: "Routeur",
            CONTENT: [
                {
                    type: "title",
                    title: "Wi-Fi 2.4 GHz / 5 GHz"
                }, {
                    type: "name",
                    title: "SSID",
                    content: "Indique le SSID des réseaux Wi-Fi 2.4 GHz ou 5 GHz diffusés."
                }, {
                    type: "name",
                    title: "Canal",
                    content: "Indique le canal d'émission des signaux Wi-Fi 2.4 GHz ou 5 GHz diffusés."
                }, {
                    type: "name",
                    title: "ADRESSE MAC",
                    content: "Indique l'adresse MAC Wi-Fi des Wi-Fi 2.4 GHz ou 5 GHz diffusés."
                }, {
                    type: "title",
                    title: "Réseau Wi-Fi 2.4 GHz/5 GHz"
                }, {
                    type: "name",
                    title: "Etat",
                    content: "Indique si le réseau invités 2.4 GHZ / 5GHz est actif ou inactif"
                }, {
                    type: "name",
                    title: "SSID",
                    content: "Indique le SSID du réseau invités."
                }
            ]
        },
        BASIC_NETWORK_CLIENTS: {
            TITLE: "Clients Filaires ou Wi-Fi",
            CONTENT: [
                {
                    type: "name",
                    title: "Nom",
                    content: "Indique le nom de l'appareil connecté au routeur."
                }, {
                    type: "name",
                    title: "Adresse IP",
                    content: "Indique l'adresse IP du client connecté au routeur."
                }, {
                    type: "name",
                    title: "Adresse MAC",
                    content: "Indique l'adresse MAC du client connecté au routeur."
                }
            ]
        },
        BASIC_NETWORK_PRINTER: {
            TITLE: "Imprimante",
            CONTENT: [
                {
                    type: "name",
                    title: "Nom",
                    content: "Indique le nom de l'imprimante connectée au routeur via un port USB."
                }
            ]
        },
        BASIC_NETWORK_USB: {
            TITLE: "Disque USB",
            CONTENT: [
                {
                    type: "name",
                    title: "Disque USB",
                    content: "Indique la marque du disque USB connectée au routeur."
                }, {
                    type: "name",
                    title: "Total ",
                    content: "Indique l'espace disque total du disque USB."
                }, {
                    type: "name",
                    title: "Disponible",
                    content: "Indique l'espace libre sur le disque USB."
                }
            ]
        },
        BASIC_INTERNET: {
            TITLE: "Internet",
            CONTENT: [
                {
                    type: "name",
                    title: "Détection auto",
                    content: "Cliquer sur ce bouton pour détecter le type de votre connexion internet."
                }, {
                    type: "note",
                    title: "Remarque",
                    content: "Si vous n'êtes pas sûr du type de votre connexion internet; utiliser la détection automatique ou contactez votre FAI pour de l'aide."
                }, {
                    type: "title",
                    title: "Type de connexion internet : IP Statique"
                }, {
                    type: "name",
                    title: "Adresse IP/Masque de sous-réseau/Passerelle par défaut/DNS primaire/DNS secondaire",
                    content: "Saisir les informations fournies par votre ISP."
                }, {
                    type: "title",
                    title: "Type de connexion internet : IP Dynamique"
                }, {
                    type: "name",
                    title: "NE pas cloner l'adresse MAC/l'adresse MAC de cet ordinateur",
                    content: "Sélectionner de cloner votre adresse MAC ou non en fonction de votre FAI."
                }, {
                    type: "title",
                    title: "Type de connexion internet : PPPoE"
                }, {
                    type: "name",
                    title: "Nom d'utilisateur / Mot de passe",
                    content: "Saisir le nom d'utilisateur et le mot de passe fournis par votre FAI. Ces champs différencient minuscules et majuscules"
                }, {
                    type: "title",
                    title: "Type de connexion internet : L2TP/PPTP"
                }, {
                    type: "name",
                    title: "Nom d'utilisateur / Mot de passe",
                    content: "Saisir le nom d'utilisateur et le mot de passe fournis par votre FAI. Ces champs différencient minuscules et majuscules"
                }, {
                    type: "name",
                    title: "Connexion secondaire (IP dynamique ou statique)",
                    children: [
                        {
                            type: "name",
                            title: "IP dynamique",
                            content: "Sélectionner dans le cas ou l'adresse IP et le masque de sous réseau sont assignés automatiquement par le FAI."
                        }, {
                            type: "name",
                            title: "IP Statique",
                            content: "Sélectionner dans le cas ou l'adresse IP, le masque de sous réseau, la passerelle, et les adresse DNS sont assignés automatiquement par le FAI, et saisir ces informations dans les champs correspondants."
                        }
                    ]
                }, {
                    type: "name",
                    title: "IP de serveur VPN/Nom de domaine",
                    content: "Saisir l'adresse IP du serveur VPN ou le nom de domaine fourni par votre FAI."
                }
            ]
        },
        BASIC_WIRELESS: {
            TITLE: "Paramètres Wi-Fi",
            CONTENT: [
                {
                    type: "name",
                    title: "Activer l'émission du Wi-Fi",
                    content: "Cocher cette case pour activer l'émission d'un signal Wi-Fi 2.4 GHz/5 GHz"
                }, {
                    type: "name",
                    title: "Nom du réseau Wi-Fi (SSID)",
                    content: "Vous pouvez conserver le SSID par défaut ou en définir un nouveau (jusqu'à 32 caractères). Champ différenciant minuscules des majuscules."
                }, {
                    type: "name",
                    title: "Cacher le SSID",
                    content: "Cocher cette case si vous souhaitez ne pas diffuser le SSID du réseau 2.4/5 GHz."
                }, {
                    type: "name",
                    title: "Mot de passe",
                    content: "Saisir dans ce champ, un mot de passe comprenant 8 à 63 caractères ASCII ou 8 à 64 caractères hexadécimaux (majuscules et minuscules différenciées)."
                }
            ]
        },
        BASIC_DEVICE_SETTINGS: {
            TITLE: "Paramètres d'appareil",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "La page des paramètres d'appareil indique les informations relatives aux périphériques USB connectés au routeur."
                }, {
                    type: "name",
                    title: "Rechercher",
                    content: "Normalement le routeur détecte automatiquement tout nouvel appareil connecté. Sinon, cliquer sur ce bouton pour détecter tout nouvel appareil et mettre à jour le contenu de cette page."
                }, {
                    type: "name",
                    title: "Volume",
                    content: "Indique le nom du volume USB."
                }, {
                    type: "name",
                    title: "Capacité",
                    content: "Indique la capacité de stockage disponible du périphérique USB."
                }, {
                    type: "name",
                    title: "Espace libre",
                    content: "Indique la capacité de stockage disponible du périphérique USB."
                }, {
                    type: "name",
                    title: "Ejecter sans risque",
                    content: "Cliquer sur ce bouton pour déconnecter proprement, le périphérique de stockage USB avant de le débrancher du routeur.",
                    children: [
                        {
                            type: "paragraph",
                            content: "Gardez en mémoire que le bouton d'éjection n'apparait qu'en présence d'un périphérique de stockage USB connecté au routeur. Gardez en mémoire qu'il est impossible de déconnecter un périphérique USB tant qu'il est en cours d'utilisation."
                        }
                    ]
                }, {
                    type: "name",
                    title: "Actif",
                    content: "Cette case à cocher n'appareil que lorsqu'un périphérique de stockage USB est connecté au routeur. Sélectionner pour activer le partage de fichier depuis le périphérique USB."
                }
            ]
        },
        BASIC_SHARING_SETTINGS: {
            TITLE: "Paramètres de partage",
            CONTENT: [
                {
                    type: "name",
                    title: "Nom du réseau / Serveur de médias",
                    content: "Indique le nom utilisé pour accéder au périphérique de stockage USB."
                }
            ]
        },
        BASIC_FOLDER_SHARING: {
            TITLE: "Partage de répertoire",
            CONTENT: [
                {
                    type: "name",
                    title: "Tout partager",
                    content: "Basculer sur Actif pour partager tous les fichiers et dossiers ou sur Inactif pour ne partager que les dossiers sélectionnés."
                }, {
                    type: "name",
                    title: "Activer l'authentification",
                    content: "Il est fortement conseillé de d'activer l'authentification pour imposer la saisie d'un nom d'utilisateur et d'un mot de passe pour accéder aux dossiers partagés."
                }, {
                    type: "name",
                    title: "Nom du répertoire",
                    content: "Indique le nom du dossier partagé."
                }, {
                    type: "name",
                    title: "Chemin du répertoire",
                    content: "Indique le chemin du répertoire partagé."
                }, {
                    type: "name",
                    title: "Partage de médias",
                    content: "Indique si le dossier partagé est autorisé pour le partage de médias ou non."
                }, {
                    type: "name",
                    title: "Nom de volume",
                    content: "Indique le nom du volume partagé."
                }, {
                    type: "name",
                    title: "Etat",
                    content: "Indique l'état du répertoire partagé par l'indicateur en forme d'ampoule. Vert (On) est actif et Gris (Off) est inactif. Vous pouvez activer ou désactiver le partage en cliquant sur l'icone ampoule."
                }, {
                    type: "name",
                    title: "Modifier",
                    content: "Affiche les options pour Modifier ou Supprimer le dossier partagé correspondant."
                }, {
                    type: "name",
                    title: "Ajouter",
                    content: "Cliquer sur ce bouton pour créer un nouvel élément."
                }, {
                    type: "name",
                    title: "Supprimer",
                    content: "Cliquer sur ce bouton pour supprimer l'élément sélectionné de la liste."
                }, {
                    type: "name",
                    title: "Naviguer",
                    content: "Cliquer pour rechercher un dossier partagé."
                }, {
                    type: "name",
                    title: "Permettre l'accès réseau aux invités",
                    content: "Sélectionner pour autoriser l'accès aux dossiers partagés aux clients du réseau invités."
                }, {
                    type: "name",
                    title: "Activer l'authentification",
                    content: "Sélectionner pour demander un nom d'utilisateur et un mot de passe aux utilisateurs pour accéder au dossiers partagés."
                }, {
                    type: "name",
                    title: "Activer l'accès en écriture",
                    content: "Sélectionner pour permettre aux utilisateurs de modifier le contenu du dossier."
                }, {
                    type: "name",
                    title: "Activer le partage de médias",
                    content: "Sélectionner pour activer le partage de dossier."
                }
            ]
        },
        BASIC_PRINT_SERVER: {
            TITLE: "Serveur d'impression",
            CONTENT: [
                {
                    type: "name",
                    title: "Activer le serveur d'impression.",
                    content: "Cliquer sur On pour activer la fonction de serveur d'impression."
                }, {
                    type: "name",
                    title: "Nom de l'imprimante",
                    content: "Indique le nom de l'imprimante connectée au routeur via un port USB. (Seules les imprimantes compatibles peuvent être partagées, l'affichage du nom n'implique pas la compatibilité de l'imprimante. Merci de consulter la liste de compatibilité la plus récente sur notre site.)"
                }, {
                    type: "step",
                    title: "Pour paramétrer un serveur d'impression dans votre réseau local",
                    content: ["1. Connecter une imprimante USB à l'aide d'un cordon au routeur.", "2. Installer les pilotes de l'imprimante sur votre ordinateur Se référer au mode d'emploi de l'ordinateur pour les instructions.", "3. Installer le contrôleur d'impression USB TP-Link soit depuis le CD (Windows) soit téléchargé (Windows, Mac OS X) depuis le site de TP-Link."]
                }
            ]
        },
        BASIC_PARENTAL_CONTROL: {
            TITLE: "Contrôle parental",
            CONTENT: [
                {
                    type: "name",
                    title: "Etat",
                    content: "Basculer sur On pour activer le contrôle parental. Par défaut cette fonction est désactivée."
                }
            ]
        },
        BASIC_PARENTAL_DEVICE: {
            TITLE: "Appareils soumis au contrôle parental",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Affiche la liste des appareils soumis au contrôle parental."
                }, {
                    type: "name",
                    title: "Nom d'appareil",
                    content: "Affiche le nom de tous les appareils clients connectés et soumis au contrôle parental."
                }, {
                    type: "name",
                    title: "Adresse MAC",
                    content: "Affiche l'adresse MAC de tous les clients connectés soumis au contrôle parental."
                }, {
                    type: "name",
                    title: "Horaire d'accès à internet",
                    content: "Indique les plages horaires de restriction d'accès."
                }, {
                    type: "name",
                    title: "Description",
                    content: "Indique une brève description de l'appareil connecté. C'est un réglage optionnel."
                }, {
                    type: "name",
                    title: "Etat",
                    content: "Affiche l'état actuel (actif ou inactif) du contrôle parental pour l'appareil correspondant."
                }, {
                    type: "name",
                    title: "Modifier",
                    content: "Indique les options pour Modifier ou Supprimer l'appareil correspondant."
                }, {
                    type: "step",
                    title: "Pour restreindre un nouvel appareil client",
                    content: [
                        "1. Cliquer sur Ajouter.",
                        "2. Cliquer sur voir les appareils et choisir l'un d'eux dans la liste des Appareils",
                        "3. Cliquer sur l'icône d'horaires d'accès à internet pour définir la période pendant laquelle des restrictions d'accès s'appliquent.",
                        "4. Saisir une brève description dans le champ Description. (Optionnel)",
                        "5. Sélectionner Activer.",
                        "6. Cliquer sur OK pour sauvegarder cet élément."
                    ]
                }, {
                    type: "paragraph",
                    content: "Pour modifier ou supprimer un élément soumis au contrôle parental, cliquer sur l'icône Modifier pour éditer les informations ou sur l'icône Supprimer pour supprimer l'élément correspondant."
                }, {
                    type: "paragraph",
                    content: "Pour supprimer plusieurs éléments, sélectionner tous les éléments puis cliquer sur Supprimer au dessus de la liste."
                }
            ]
        },
        BASIC_GUEST_NETWORK: {
            TITLE: "Réseau invités",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Le réseau invités vous permet de définir un réseau distinct disposant de son propre SSID et de son mot de passe que vos invités peuvent utiliser pour accéder à votre réseau."
                }, {
                    type: "name",
                    title: "Permet au invités de se voir mutuellement",
                    content: "Cocher cette case pour permettre aux clients du réseau invités (Wi-Fi) de se voir."
                }, {
                    type: "name",
                    title: "Interdire aux invité d'administrer mon réseau.",
                    content: "Sélectionner cette option pour interdire l'accès à l'interface Web d'administration aux invités."
                }, {
                    type: "name",
                    title: "Activer le réseau invités",
                    content: "Cocher cette case pour activer l'émission du signal Wi-Fi 2.4/5 GHz"
                }, {
                    type: "name",
                    title: "Nom du réseau Wi-Fi (SSID)",
                    content: "Utiliser le SSID invités par défaut ou saisir un nouveau nom (de 32 caractères au maximum)."
                }, {
                    type: "name",
                    title: "Cacher le SSID",
                    content: "Cocher cette case si vous souhaitez ne pas diffuser le SSID du réseau invités."
                }, {
                    type: "name",
                    title: "Mot de passe",
                    content: "Générer un mot de passe comprenant 8 à 63 caractères ASCII, ou entre 8 et 64 caractères hexadécimaux (0-9, A-F, a-f) pour sécuriser le réseau invités."
                }
            ]
        },
        "": ""
    };
})(jQuery);
